/*
 * Decompiled with CFR 0.152.
 */
package act;

import act.app.ActionContext;
import act.conf.AppConfig;
import java.util.Locale;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.mvc.MvcConfig;
import org.osgl.mvc.result.Ok;
import org.osgl.mvc.result.Redirect;
import org.osgl.mvc.result.Result;
import org.osgl.util.E;

public abstract class ActResponse<T extends ActResponse>
extends H.Response<T> {
    private boolean ready;
    private boolean closed;
    protected String charset;
    protected Locale locale;
    protected String contentType;
    protected H.Format fmt;
    private boolean charsetSet;
    protected int statusCode = -1;

    protected ActResponse() {
    }

    protected ActResponse(AppConfig config) {
        this.charset = config.encoding();
        this.locale = config.locale();
    }

    public String characterEncoding() {
        return this.charset;
    }

    public T characterEncoding(String encoding) {
        this.charset = encoding;
        this.charsetSet = true;
        return (T)this.me();
    }

    public T sendError(int sc, String msg) {
        throw E.unsupport();
    }

    public T sendError(int sc) {
        throw E.unsupport();
    }

    public T sendRedirect(String location) {
        throw new Redirect(location);
    }

    public T contentType(H.Format fmt) {
        this.contentType(fmt.contentType());
        this.fmt = fmt;
        return (T)this.me();
    }

    public H.Format lastContentType() {
        return this.fmt;
    }

    public void markReady() {
        this.ready = true;
    }

    public void commitContentType() {
        this.header("Content-Type", this._getContentType());
    }

    public void close() {
        super.close();
        this.markClosed();
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void markClosed() {
        this.closed = true;
    }

    protected abstract void _setStatusCode(int var1);

    public T status(int sc) {
        E.illegalArgumentIf((sc < 100 ? 1 : 0) != 0, (String)"Invalid status code");
        this.statusCode = sc;
        this._setStatusCode(sc);
        return (T)this.me();
    }

    public int statusCode() {
        return this.statusCode;
    }

    public void beforeWritingContent() {
        if (this.ready) {
            return;
        }
        ActionContext ctx = (ActionContext)this.context();
        ctx.dissolve();
        MvcConfig.applyBeforeCommitResultHandler((Result)Ok.get(), (H.Request)ctx.req(), (H.Response)this);
    }

    public void afterWritingContent() {
        if (this.ready) {
            return;
        }
        this.commit();
        ActionContext ctx = (ActionContext)this.context();
        MvcConfig.applyAfterCommitResultHandler((Result)Ok.get(), (H.Request)ctx.req(), (H.Response)this);
    }

    protected void _setContentType(String type) {
        this.contentType = type;
    }

    protected String _getContentType() {
        return this.contentType != null ? (this.charsetSet ? this.contentType + ";charset=" + this.charset : this.contentType) : null;
    }

    protected final T me() {
        return (T)((Object)this);
    }

    private ActionContext ctx() {
        return (ActionContext)$.cast((Object)this.context());
    }
}

