/*
 * Decompiled with CFR 0.152.
 */
package act;

import act.Destroyable;
import act.app.App;
import act.asm.ClassWriter;
import act.util.AppByteCodeEnhancer;
import act.util.AsmByteCodeEnhancer;
import act.util.ByteCodeVisitor;
import act.util.DestroyableBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.Lang;

public class BytecodeEnhancerManager
extends DestroyableBase {
    private List<AppByteCodeEnhancer> appEnhancers = new ArrayList<AppByteCodeEnhancer>();
    private List<AsmByteCodeEnhancer> generalEnhancers = new ArrayList<AsmByteCodeEnhancer>();

    public void register(AsmByteCodeEnhancer enhancer) {
        if (enhancer instanceof AppByteCodeEnhancer) {
            this.appEnhancers.add((AppByteCodeEnhancer)enhancer);
        } else {
            this.generalEnhancers.add(enhancer);
        }
    }

    public void register(AppByteCodeEnhancer enhancer) {
        this.appEnhancers.add(enhancer);
    }

    public void registered() {
        Collections.sort(this.appEnhancers);
    }

    public ByteCodeVisitor appEnhancer(App app, String className, Lang.Var<ClassWriter> cw) {
        List<AppByteCodeEnhancer> l = this.appFilter(app, className);
        return l.isEmpty() ? null : ByteCodeVisitor.chain(cw, l);
    }

    public ByteCodeVisitor generalEnhancer(String className, Lang.Var<ClassWriter> cw) {
        List<AsmByteCodeEnhancer> l = this.generalFilter(className);
        return l.isEmpty() ? null : ByteCodeVisitor.chain(cw, l);
    }

    private List<AppByteCodeEnhancer> appFilter(App app, String className) {
        ArrayList<AppByteCodeEnhancer> l = new ArrayList<AppByteCodeEnhancer>();
        for (AppByteCodeEnhancer e : this.appEnhancers) {
            AppByteCodeEnhancer e0 = (AppByteCodeEnhancer)e.clone();
            e0.app(app);
            if (!e0.isTargetClass(className)) continue;
            l.add(e0);
        }
        return l;
    }

    private List<AsmByteCodeEnhancer> generalFilter(String className) {
        ArrayList<AsmByteCodeEnhancer> l = new ArrayList<AsmByteCodeEnhancer>();
        for (AsmByteCodeEnhancer e : this.generalEnhancers) {
            Object e0 = e.clone();
            if (!((AsmByteCodeEnhancer)e0).isTargetClass(className)) continue;
            l.add((AsmByteCodeEnhancer)((AsmByteCodeEnhancer)e0).clone());
        }
        return l;
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.appEnhancers, ApplicationScoped.class);
        this.appEnhancers.clear();
        Destroyable.Util.tryDestroyAll(this.generalEnhancers, ApplicationScoped.class);
        this.generalEnhancers.clear();
    }
}

