/*
 * Decompiled with CFR 0.152.
 */
package act;

import act.Act;
import act.ActResponse;
import act.apidoc.Description;
import act.app.ActionContext;
import act.app.App;
import act.cli.Command;
import act.handler.NonBlock;
import act.inject.param.NoBind;
import act.sys.Env;
import act.util.Banner;
import act.util.ByteBuffers;
import act.util.JsonView;
import com.alibaba.fastjson.JSON;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.http.H;
import org.osgl.mvc.annotation.GetAction;
import org.osgl.util.C;
import org.osgl.util.S;

@Singleton
public class Info {
    @NoBind
    private Map<String, Object> versionData;
    private Unit info;
    private Unit pid;
    private Unit version;

    @Inject
    public Info(App app) {
        this.init(app);
    }

    @GetAction(value={"info"})
    @NonBlock
    @Description(value="Show application info including version, scan package, base dir and profile")
    public void show(ActionContext context) {
        this.info.applyTo(context);
    }

    @GetAction(value={"pid"})
    @NonBlock
    @Description(value="Get process id")
    public void pid(ActionContext context) {
        this.pid.applyTo(context);
    }

    @NonBlock
    @JsonView
    @GetAction(value={"version"})
    @Description(value="Get version info in JSON format. This include both application version and actframework version.")
    public void version(ActionContext context) {
        this.version.applyTo(context);
    }

    @Command(name="act.version, act.ver", help="Print app/actframework version")
    public Map<String, Object> getVersions() {
        return this.versionData;
    }

    private void init(App app) {
        this.initPidBuffer();
        this.initInfoBuffer(app);
        this.initVersion();
    }

    private void initPidBuffer() {
        this.pid = new Unit("pid", (Object)Env.PID.get());
    }

    private void initInfoBuffer(App app) {
        C.Map map = C.Map((Object[])new Object[]{"actVersion", Act.VERSION.getVersion(), "appVersion", Act.appVersion().getVersion(), "appName", app.name(), "pid", Env.PID.get(), "baseDir", app.base().getAbsoluteFile(), "mode", Act.mode().name(), "profile", Act.profile(), "group", Act.nodeGroup()});
        this.info = new Unit((Map<String, Object>)map, Banner.cachedBanner());
    }

    private void initVersion() {
        this.versionData = C.Map((Object[])new Object[]{"act", Act.VERSION, "app", Act.appVersion()});
        this.version = new Unit(this.versionData);
    }

    @NoBind
    public static class Unit {
        private static final String CNT_TXT = H.Format.TXT.contentType();
        private static final String CNT_JSON = H.Format.JSON.contentType();
        ByteBuffer json;
        ByteBuffer txt;

        public Unit(Map<String, Object> data) {
            this(data, JSON.toJSONString(data));
        }

        public Unit(Map<String, Object> data, String txt) {
            this.json = ByteBuffers.wrap(JSON.toJSONString(data));
            this.txt = ByteBuffers.wrap(txt);
        }

        public Unit(String name, Object val) {
            this.json = ByteBuffers.wrap(JSON.toJSONString((Object)C.Map((Object[])new Object[]{name, val})));
            this.txt = ByteBuffers.wrap(S.string((Object)val));
        }

        public void applyTo(ActionContext context) {
            ActResponse<?> resp = context.resp();
            if (context.acceptJson()) {
                resp.contentType(CNT_JSON);
                resp.writeContent(this.json.duplicate());
            } else {
                resp.contentType(CNT_TXT);
                resp.writeContent(this.txt.duplicate());
            }
        }
    }
}

