/*
 * Decompiled with CFR 0.152.
 */
package act;

import org.joda.time.DateTime;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;

public class Trace {
    public static final Logger LOGGER_REQUEST = LogManager.get((String)"act.trace.request");
    public static final Logger LOGGER_HANDLER = LogManager.get((String)"act.trace.handler");

    public static class AccessLog {
        private H.Method method;
        private String url;
        private String remoteAddress;
        private String userAgent;
        private String time;

        public void logWithResponseCode(int responseCode) {
            LOGGER_REQUEST.trace("%s [%s] \"%s\" %s %s", new Object[]{this.remoteAddress, this.time, this.method.name(), this.url, responseCode, this.userAgent});
        }

        public static AccessLog create(H.Request req) {
            AccessLog log = new AccessLog();
            log.method = req.method();
            log.url = req.url();
            log.remoteAddress = req.ip();
            log.userAgent = req.userAgentStr();
            log.time = DateTime.now().toString();
            return log;
        }
    }
}

