/*
 * Decompiled with CFR 0.152.
 */
package act.apidoc;

import act.Act;
import act.apidoc.ApiManager;
import act.apidoc.BeanSpecInterpreter;
import act.apidoc.Description;
import act.app.data.StringValueResolverManager;
import act.data.Sensitive;
import act.handler.RequestHandler;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.handler.builtin.controller.impl.ReflectedHandlerInvoker;
import act.inject.DefaultValue;
import act.inject.DependencyInjector;
import act.inject.param.ParamValueLoaderService;
import act.validation.NotBlank;
import com.alibaba.fastjson.JSON;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.bval.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Injector;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.Result;
import org.osgl.storage.ISObject;
import org.osgl.util.C;
import org.osgl.util.Generics;
import org.osgl.util.N;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public class Endpoint
implements Comparable<Endpoint> {
    private static final Logger LOGGER = ApiManager.LOGGER;
    private static BeanSpecInterpreter beanSpecInterpretor = new BeanSpecInterpreter();
    private String id;
    private Scheme scheme = Scheme.HTTP;
    private int port;
    private H.Method httpMethod;
    private String path;
    private String handler;
    private String description;
    private Class<?> returnType;
    private String returnSample;
    private List<ParamInfo> params = new ArrayList<ParamInfo>();
    private String sampleJsonPost;
    private String sampleQuery;
    private Class<?> controllerClass;
    private static final Lang.Predicate<Field> FIELD_PREDICATE = new Lang.Predicate<Field>(){

        public boolean test(Field field) {
            return !ParamValueLoaderService.shouldWaive(field);
        }
    };

    Endpoint(int port, H.Method httpMethod, String path, RequestHandler handler) {
        this.httpMethod = (H.Method)$.notNull((Object)httpMethod);
        this.path = (String)$.notNull((Object)path);
        this.handler = handler.toString();
        this.port = port;
        this.explore(handler);
    }

    @Override
    public int compareTo(Endpoint o) {
        int n = this.path.compareTo(o.path);
        if (0 != n) {
            return n;
        }
        return this.httpMethod.ordinal() - o.httpMethod.ordinal();
    }

    public String getId() {
        return this.id;
    }

    public String getXid() {
        return S.concat((Object)this.httpMethod, (Object)this.id.replace('.', '_'));
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public H.Method getHttpMethod() {
        return this.httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public String getHandler() {
        return this.handler;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ParamInfo> getParams() {
        return this.params;
    }

    public Class<?> returnType() {
        return this.returnType;
    }

    public String getReturnSample() {
        return this.returnSample;
    }

    public String getReturnType() {
        if (Void.TYPE == this.returnType || Void.class == this.returnType) {
            return null;
        }
        return this.className(this.returnType);
    }

    public String getSampleJsonPost() {
        return this.sampleJsonPost;
    }

    public String getSampleQuery() {
        return this.sampleQuery;
    }

    public Class<?> controllerClass() {
        return this.controllerClass;
    }

    private void explore(RequestHandler handler) {
        RequestHandlerProxy proxy = (RequestHandlerProxy)$.cast((Object)handler);
        ReflectedHandlerInvoker invoker = (ReflectedHandlerInvoker)$.cast((Object)proxy.actionHandler().invoker());
        Class<?> controllerClass = invoker.controllerClass();
        Method method = invoker.method();
        this.id = this.id(method);
        this.returnType = method.getReturnType();
        this.returnSample = Endpoint.generateSampleJson(BeanSpec.of((Type)method.getGenericReturnType(), null, Act.injector()));
        Description descAnno = method.getAnnotation(Description.class);
        this.description = null == descAnno ? this.methodDescription(method) : descAnno.value();
        this.exploreParamInfo(method);
        if (!Modifier.isStatic(method.getModifiers())) {
            this.exploreParamInfo(controllerClass);
        }
        this.controllerClass = controllerClass;
    }

    private String methodDescription(Method method) {
        return this.id(method);
    }

    private String id(Method method) {
        Class<?> hosting = method.getDeclaringClass();
        return this.className(hosting) + "." + method.getName();
    }

    private String className(Class<?> clz) {
        Class<?> enclosing = clz.getEnclosingClass();
        if (null != enclosing) {
            return this.className(enclosing) + "." + clz.getSimpleName();
        }
        return clz.getSimpleName();
    }

    private void exploreParamInfo(Method method) {
        Type[] paramTypes = method.getGenericParameterTypes();
        int paramCount = paramTypes.length;
        if (0 == paramCount) {
            return;
        }
        Object injector = Act.injector();
        Annotation[][] allAnnos = method.getParameterAnnotations();
        HashMap<String, Object> sampleData = new HashMap<String, Object>();
        StringValueResolverManager resolver = Act.app().resolverManager();
        ArrayList<String> sampleQuery = new ArrayList<String>();
        for (int i = 0; i < paramCount; ++i) {
            Type type = paramTypes[i];
            Annotation[] annos = allAnnos[i];
            ParamInfo info = this.paramInfo(type, annos, (DependencyInjector)injector, null);
            if (null == info) continue;
            this.params.add(info);
            if (this.path.contains("{" + info.getName() + "}")) continue;
            Object sample = null != info.defaultValue ? resolver.resolve(info.defaultValue, info.beanSpec.rawType()) : Endpoint.generateSampleData(info.beanSpec, new HashSet());
            if (H.Method.GET == this.httpMethod) {
                String query = Endpoint.generateSampleQuery(info.beanSpec, info.bindName);
                if (!S.notBlank((String)query)) continue;
                sampleQuery.add(query);
                continue;
            }
            sampleData.put(info.bindName, sample);
        }
        if (!sampleData.isEmpty()) {
            this.sampleJsonPost = JSON.toJSONString(sampleData, (boolean)true);
        }
        if (!sampleQuery.isEmpty()) {
            this.sampleQuery = S.join((String)"&", sampleQuery);
        }
    }

    private void exploreParamInfo(Class<?> controller) {
        Object injector = Act.injector();
        List fields = $.fieldsOf(controller, FIELD_PREDICATE);
        for (Field field : fields) {
            Annotation[] annos;
            Type type = field.getGenericType();
            ParamInfo info = this.paramInfo(type, annos = field.getAnnotations(), (DependencyInjector)injector, field.getName());
            if (null == info) continue;
            this.params.add(info);
        }
    }

    private ParamInfo paramInfo(Type type, Annotation[] annos, DependencyInjector injector, String name) {
        if (this.isLoginUser(annos)) {
            return null;
        }
        BeanSpec spec = BeanSpec.of((Type)type, (Annotation[])annos, (String)name, (Injector)injector);
        if (ParamValueLoaderService.providedButNotDbBind(spec, injector)) {
            return null;
        }
        if (ParamValueLoaderService.hasDbBind(spec.allAnnotations())) {
            if (S.blank((String)name)) {
                name = spec.name();
            }
            return new ParamInfo(name, BeanSpec.of(String.class, Act.injector()), name + " id");
        }
        String description = "";
        Description descAnno = (Description)spec.getAnnotation(Description.class);
        if (null != descAnno) {
            description = descAnno.value();
        }
        return new ParamInfo(spec.name(), spec, description);
    }

    private boolean isLoginUser(Annotation[] annos) {
        for (Annotation a : annos) {
            if (!"LoginUser".equals(a.annotationType().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private static String generateSampleJson(BeanSpec spec) {
        Class type = spec.rawType();
        if (Result.class.isAssignableFrom(type)) {
            return null;
        }
        Object sample = Endpoint.generateSampleData(spec, new HashSet());
        if (null == sample) {
            return null;
        }
        if ($.isSimpleType((Class)type)) {
            sample = C.Map((Object[])new Object[]{"result", sample});
        }
        return JSON.toJSONString((Object)sample, (boolean)true);
    }

    private static String generateSampleQuery(BeanSpec spec, String bindName) {
        Class type = spec.rawType();
        if ($.isSimpleType((Class)type)) {
            return bindName + "=" + Endpoint.generateSampleData(spec, new HashSet());
        }
        if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            BeanSpec elementSpec = BeanSpec.of(elementType, Act.injector());
            if ($.isSimpleType(elementType)) {
                return bindName + "=" + Endpoint.generateSampleData(elementSpec, new HashSet()) + "&" + bindName + "=" + Endpoint.generateSampleData(elementSpec, new HashSet());
            }
        } else if (Collection.class.isAssignableFrom(type)) {
            List typeParams = spec.typeParams();
            Object elementType = typeParams.isEmpty() ? Object.class : (Type)typeParams.get(0);
            BeanSpec elementSpec = BeanSpec.of(elementType, null, Act.injector());
            if ($.isSimpleType((Class)elementSpec.rawType())) {
                return bindName + "=" + Endpoint.generateSampleData(elementSpec, new HashSet()) + "&" + bindName + "=" + Endpoint.generateSampleData(elementSpec, new HashSet());
            }
        } else {
            if (Map.class.isAssignableFrom(type)) {
                LOGGER.warn("Map not supported yet");
                return "";
            }
            if (ReadableInstant.class.isAssignableFrom(type)) {
                return bindName + "=<datetime>";
            }
        }
        if (null != Endpoint.stringValueResolver(type)) {
            return bindName + "=" + S.random((int)5);
        }
        ArrayList<String> queryPairs = new ArrayList<String>();
        List fields = $.fieldsOf((Class)type);
        for (Field field : fields) {
            if (ParamValueLoaderService.shouldWaive(field)) continue;
            String fieldBindName = bindName + "." + field.getName();
            String pair = Endpoint.generateSampleQuery(BeanSpec.of((Field)field, Act.injector()), fieldBindName);
            queryPairs.add(pair);
        }
        return S.join((String)"&", queryPairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object generateSampleData(BeanSpec spec, Set<Class<?>> typeChain) {
        Class type = spec.rawType();
        if (typeChain.contains(type)) {
            return null;
        }
        typeChain.add(type);
        try {
            if (Void.TYPE == type || Void.class == type || Result.class.isAssignableFrom(type)) {
                Object var3_3 = null;
                return var3_3;
            }
            if (Object.class == type) {
                String string = "<Any>";
                return string;
            }
            if (type.isEnum()) {
                T[] ea = type.getEnumConstants();
                int len = ea.length;
                Object var5_29 = 0 < len ? ea[N.randInt((int)len)] : null;
                return var5_29;
            }
            if (Locale.class == type) {
                Locale ea = Locale.getDefault();
                return ea;
            }
            if (String.class == type) {
                String mockValue = S.random((int)5);
                if (spec.hasAnnotation(Sensitive.class)) {
                    String len = Act.crypto().encrypt(mockValue);
                    return len;
                }
                String len = S.random((int)5);
                return len;
            }
            if (type.isArray()) {
                Object sample = Array.newInstance(type.getComponentType(), 2);
                Array.set(sample, 0, Endpoint.generateSampleData(BeanSpec.of(type.getComponentType(), Act.injector()), typeChain));
                Array.set(sample, 1, Endpoint.generateSampleData(BeanSpec.of(type.getComponentType(), Act.injector()), typeChain));
                Object len = sample;
                return len;
            }
            if ($.isSimpleType((Class)type)) {
                if (Enum.class == type) {
                    String sample = "<Any Enum>";
                    return sample;
                }
                if (!type.isPrimitive()) {
                    type = $.primitiveTypeOf((Class)type);
                }
                Object sample = ((StringValueResolver)StringValueResolver.predefined().get(type)).resolve(null);
                return sample;
            }
            if (LocalDateTime.class.isAssignableFrom(type)) {
                LocalDateTime sample = LocalDateTime.now();
                return sample;
            }
            if (DateTime.class.isAssignableFrom(type)) {
                DateTime sample = DateTime.now();
                return sample;
            }
            if (LocalDate.class.isAssignableFrom(type)) {
                LocalDate sample = LocalDate.now();
                return sample;
            }
            if (LocalTime.class.isAssignableFrom(type)) {
                LocalTime sample = LocalTime.now();
                return sample;
            }
            if (Date.class.isAssignableFrom(type)) {
                Date sample = new Date();
                return sample;
            }
            if (type.getName().contains(".ObjectId")) {
                String sample = "<id>";
                return sample;
            }
            if (BigDecimal.class == type) {
                BigDecimal sample = BigDecimal.valueOf(1.1);
                return sample;
            }
            if (BigInteger.class == type) {
                BigInteger sample = BigInteger.valueOf(1L);
                return sample;
            }
            if (ISObject.class.isAssignableFrom(type)) {
                Object sample = null;
                return sample;
            }
            if (Map.class.isAssignableFrom(type)) {
                Map map = (Map)$.cast(Act.getInstance(type));
                List typeParams = spec.typeParams();
                if (typeParams.isEmpty()) {
                    typeParams = Generics.typeParamImplementations((Class)type, Map.class);
                }
                if (typeParams.size() < 2) {
                    map.put(S.random(), S.random());
                    map.put(S.random(), S.random());
                } else {
                    Type keyType = (Type)typeParams.get(0);
                    Type valType = (Type)typeParams.get(1);
                    map.put(Endpoint.generateSampleData(BeanSpec.of((Type)keyType, null, Act.injector()), typeChain), Endpoint.generateSampleData(BeanSpec.of((Type)valType, null, Act.injector()), typeChain));
                    map.put(Endpoint.generateSampleData(BeanSpec.of((Type)keyType, null, Act.injector()), typeChain), Endpoint.generateSampleData(BeanSpec.of((Type)valType, null, Act.injector()), typeChain));
                }
            } else if (Iterable.class.isAssignableFrom(type)) {
                Collection col = (Collection)$.cast(Act.getInstance(type));
                List typeParams = spec.typeParams();
                if (typeParams.isEmpty()) {
                    typeParams = Generics.typeParamImplementations((Class)type, Map.class);
                }
                if (typeParams.isEmpty()) {
                    col.add(S.random());
                } else {
                    Type componentType = (Type)typeParams.get(0);
                    col.add(Endpoint.generateSampleData(BeanSpec.of((Type)componentType, null, Act.injector()), typeChain));
                    col.add(Endpoint.generateSampleData(BeanSpec.of((Type)componentType, null, Act.injector()), typeChain));
                }
                Collection collection = col;
                return collection;
            }
            if (null != Endpoint.stringValueResolver(type)) {
                String col = S.random((int)5);
                return col;
            }
            Object obj = Act.getInstance(type);
            List fields = $.fieldsOf((Class)type);
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers()) || ParamValueLoaderService.shouldWaive(field)) continue;
                Class<?> fieldType = field.getType();
                Object val = null;
                try {
                    field.setAccessible(true);
                    val = Endpoint.generateSampleData(BeanSpec.of((Field)field, Act.injector()), typeChain);
                    Class<?> valType = null == val ? null : val.getClass();
                    if (null == valType || !fieldType.isAssignableFrom(valType)) continue;
                    field.set(obj, val);
                }
                catch (Exception e) {
                    LOGGER.warn("Error setting value[%s] to field[%s.%s]", new Object[]{val, type.getSimpleName(), field.getName()});
                }
            }
            Iterator<Object> iterator = obj;
            return iterator;
        }
        finally {
            typeChain.remove(type);
        }
    }

    private static <T> StringValueResolver stringValueResolver(Class<? extends T> type) {
        return Act.app().resolverManager().resolver(type);
    }

    public static enum Scheme {
        HTTP;

    }

    public static class ParamInfo {
        private String bindName;
        private BeanSpec beanSpec;
        private String description;
        private String defaultValue;
        private boolean required;
        private List<String> options;

        private ParamInfo(String bindName, BeanSpec beanSpec, String description) {
            this.bindName = bindName;
            this.beanSpec = beanSpec;
            this.description = description;
            this.defaultValue = this.checkDefaultValue(beanSpec);
            this.required = this.checkRequired(beanSpec);
            this.options = this.checkOptions(beanSpec);
        }

        public String getName() {
            return this.bindName;
        }

        public String getType() {
            return beanSpecInterpretor.interpret(this.beanSpec);
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        private String checkDefaultValue(BeanSpec spec) {
            DefaultValue def = (DefaultValue)spec.getAnnotation(DefaultValue.class);
            if (null != def) {
                return def.value();
            }
            Class type = spec.rawType();
            if (type.isPrimitive()) {
                Object o = Act.app().resolverManager().resolve("", type);
                return null != o ? o.toString() : null;
            }
            return null;
        }

        private boolean checkRequired(BeanSpec spec) {
            return spec.hasAnnotation(NotNull.class) || spec.hasAnnotation(NotBlank.class) || spec.hasAnnotation(NotEmpty.class);
        }

        private List<String> checkOptions(BeanSpec spec) {
            Class type = spec.rawType();
            if (type.isEnum()) {
                return C.listOf((Object[])type.getEnumConstants()).map((Lang.Function)Lang.F.asString());
            }
            return null;
        }
    }
}

