/*
 * Decompiled with CFR 0.152.
 */
package act.apidoc.javadoc;

import act.apidoc.javadoc.JavadocDescription;
import act.apidoc.javadoc.Utils;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.S;

public class JavadocBlockTag {
    private Type type;
    private JavadocDescription content;
    private Lang.Option<String> name = $.none();
    private String tagName;

    public JavadocBlockTag(Type type, String content) {
        this.type = type;
        this.tagName = type.keyword;
        if (type.hasName()) {
            this.name = $.some((Object)Utils.nextWord(content));
            content = content.substring(((String)this.name.get()).length()).trim();
        }
        this.content = JavadocDescription.parseText(content);
    }

    public JavadocBlockTag(String tagName, String content) {
        this(Type.fromName(tagName), content);
        this.tagName = tagName;
    }

    public static JavadocBlockTag createParamBlockTag(String paramName, String content) {
        return new JavadocBlockTag(Type.PARAM, paramName + " " + content);
    }

    public Type getType() {
        return this.type;
    }

    public JavadocDescription getContent() {
        return this.content;
    }

    public Lang.Option<String> getName() {
        return this.name;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(this.tagName);
        if (this.name.isDefined()) {
            sb.append(" ").append((String)this.name.get());
        }
        if (!this.content.isEmpty()) {
            sb.append(" ");
            sb.append(this.content.toText());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavadocBlockTag that = (JavadocBlockTag)o;
        if (this.type != that.type) {
            return false;
        }
        if (!this.content.equals(that.content)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.content.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "JavadocBlockTag{type=" + (Object)((Object)this.type) + ", content='" + this.content + '\'' + ", name=" + this.name + '}';
    }

    public static enum Type {
        AUTHOR,
        DEPRECATED,
        EXCEPTION,
        PARAM,
        RETURN,
        SEE,
        SERIAL,
        SERIAL_DATA,
        SERIAL_FIELD,
        SINCE,
        THROWS,
        VERSION,
        UNKNOWN;

        private String keyword = S.camelCase((CharSequence)this.name());

        boolean hasName() {
            return this == PARAM;
        }

        static Type fromName(String tagName) {
            for (Type t : Type.values()) {
                if (!t.keyword.equalsIgnoreCase(tagName)) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

