/*
 * Decompiled with CFR 0.152.
 */
package act.apidoc.javadoc;

import act.apidoc.javadoc.JavadocDescriptionElement;
import act.apidoc.javadoc.JavadocInlineTag;
import act.apidoc.javadoc.JavadocSnippet;
import java.util.LinkedList;
import java.util.List;
import org.osgl.$;
import org.osgl.Lang;

public class JavadocDescription {
    private List<JavadocDescriptionElement> elements = new LinkedList<JavadocDescriptionElement>();

    public static JavadocDescription parseText(String text) {
        Lang.T2<Integer, Integer> nextInlineTagPos;
        JavadocDescription instance = new JavadocDescription();
        int index = 0;
        while ((nextInlineTagPos = JavadocDescription.indexOfNextInlineTag(text, index)) != null) {
            if ((Integer)nextInlineTagPos._1 != index) {
                instance.addElement(new JavadocSnippet(text.substring(index, (Integer)nextInlineTagPos._1 + 1)));
            }
            instance.addElement(JavadocInlineTag.fromText(text.substring((Integer)nextInlineTagPos._1, (Integer)nextInlineTagPos._2 + 1)));
            index = (Integer)nextInlineTagPos._2;
        }
        if (index < text.length()) {
            instance.addElement(new JavadocSnippet(text.substring(index)));
        }
        return instance;
    }

    private static Lang.T2<Integer, Integer> indexOfNextInlineTag(String text, int start) {
        int index = text.indexOf("{@", start);
        if (index == -1) {
            return null;
        }
        int closeIndex = text.indexOf("}", index);
        if (closeIndex == -1) {
            return null;
        }
        return $.T2((Object)index, (Object)closeIndex);
    }

    public JavadocDescription() {
    }

    public JavadocDescription(List<JavadocDescriptionElement> elements) {
        this();
        this.elements.addAll(elements);
    }

    public boolean addElement(JavadocDescriptionElement element) {
        return this.elements.add(element);
    }

    public List<JavadocDescriptionElement> getElements() {
        return this.elements;
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        for (JavadocDescriptionElement e : this.elements) {
            sb.append(e.toText());
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.toText().isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavadocDescription that = (JavadocDescription)o;
        return this.elements.equals(that.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return "JavadocDescription{elements=" + this.elements + '}';
    }
}

