/*
 * Decompiled with CFR 0.152.
 */
package act.apidoc.javadoc;

import act.apidoc.javadoc.Javadoc;
import act.apidoc.javadoc.JavadocBlockTag;
import act.apidoc.javadoc.JavadocDescription;
import act.apidoc.javadoc.Utils;
import com.github.javaparser.ast.comments.JavadocComment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.osgl.util.S;
import org.osgl.util.VM;

public class JavadocParser {
    private static final String EOL = System.getProperty("line.separator");
    private static String BLOCK_TAG_PREFIX = "@";
    private static Pattern BLOCK_PATTERN = Pattern.compile("^" + BLOCK_TAG_PREFIX, 8);

    public static Javadoc parse(JavadocComment comment) {
        return JavadocParser.parse(comment.getContent());
    }

    public static Javadoc parse(String commentContent) {
        List<String> blockLines;
        String descriptionText;
        List<String> cleanLines = JavadocParser.cleanLines(JavadocParser.normalizeEolInTextBlock(commentContent, EOL));
        int indexOfFirstBlockTag = -1;
        int j = cleanLines.size();
        for (int i = 0; i < j; ++i) {
            String line = cleanLines.get(i);
            if (!JavadocParser.isABlockLine(line)) continue;
            indexOfFirstBlockTag = i;
            break;
        }
        if (indexOfFirstBlockTag == -1) {
            descriptionText = JavadocParser.trimRight(S.join((String)EOL, cleanLines));
            blockLines = Collections.emptyList();
        } else {
            descriptionText = JavadocParser.trimRight(S.join((String)EOL, cleanLines.subList(0, indexOfFirstBlockTag)));
            String tagBlock = S.join((String)EOL, cleanLines.subList(indexOfFirstBlockTag, cleanLines.size()));
            String[] sa = BLOCK_PATTERN.split(tagBlock);
            blockLines = new ArrayList<String>();
            for (String s : sa) {
                if (!S.notEmpty((String)s)) continue;
                blockLines.add(BLOCK_TAG_PREFIX + s);
            }
        }
        Javadoc document = new Javadoc(JavadocDescription.parseText(descriptionText));
        for (String line : blockLines) {
            document.addBlockTag(JavadocParser.parseBlockTag(line));
        }
        return document;
    }

    private static JavadocBlockTag parseBlockTag(String line) {
        line = line.trim().substring(1);
        String tagName = Utils.nextWord(line);
        String rest = line.substring(tagName.length()).trim();
        return new JavadocBlockTag(tagName, rest);
    }

    private static boolean isABlockLine(String line) {
        return line.trim().startsWith(BLOCK_TAG_PREFIX);
    }

    private static String trimRight(String string) {
        while (!string.isEmpty() && Character.isWhitespace(string.charAt(string.length() - 1))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static List<String> cleanLines(String content) {
        String[] lines = content.split(EOL);
        List<String> cleanedLines = new ArrayList<String>();
        for (String line : lines) {
            char c;
            int asteriskIndex = JavadocParser.startsWithAsterisk(line);
            if (asteriskIndex == -1) {
                cleanedLines.add(S.trim((String)line));
                continue;
            }
            if (line.length() > asteriskIndex + 1 && ((c = line.charAt(asteriskIndex + 1)) == ' ' || c == '\t')) {
                cleanedLines.add(line.substring(asteriskIndex + 2));
                continue;
            }
            cleanedLines.add(line.substring(asteriskIndex + 1));
        }
        if (!(((String)cleanedLines.get(0)).isEmpty() || ((String)cleanedLines.get(0)).charAt(0) != ' ' && ((String)cleanedLines.get(0)).charAt(0) != '\t')) {
            cleanedLines.set(0, ((String)cleanedLines.get(0)).substring(1));
        }
        while (cleanedLines.size() > 0 && ((String)cleanedLines.get(0)).trim().isEmpty()) {
            cleanedLines = cleanedLines.subList(1, cleanedLines.size());
        }
        while (cleanedLines.size() > 0 && ((String)cleanedLines.get(cleanedLines.size() - 1)).trim().isEmpty()) {
            cleanedLines = cleanedLines.subList(0, cleanedLines.size() - 1);
        }
        return cleanedLines;
    }

    static int startsWithAsterisk(String line) {
        if (line.startsWith("*")) {
            return 0;
        }
        if ((line.startsWith(" ") || line.startsWith("\t")) && line.length() > 1) {
            int res = JavadocParser.startsWithAsterisk(line.substring(1));
            if (res == -1) {
                return -1;
            }
            return 1 + res;
        }
        return -1;
    }

    public static String normalizeEolInTextBlock(String content, String endOfLineCharacter) {
        String regex = "\\R";
        if (VM.VERSION < 8) {
            regex = "[(\\r\\n)\\n\\r]";
        }
        return content.replaceAll(regex, endOfLineCharacter);
    }
}

