/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.app.ActionContext;
import act.app.App;
import act.app.AppServiceBase;
import act.handler.builtin.controller.AfterInterceptor;
import act.handler.builtin.controller.BeforeInterceptor;
import act.handler.builtin.controller.ExceptionInterceptor;
import act.handler.builtin.controller.FinallyInterceptor;
import act.handler.builtin.controller.RequestHandlerProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgl.mvc.result.Result;

public class AppInterceptorManager
extends AppServiceBase<AppInterceptorManager> {
    private List<BeforeInterceptor> beforeInterceptors = new ArrayList<BeforeInterceptor>();
    private List<AfterInterceptor> afterInterceptors = new ArrayList<AfterInterceptor>();
    private List<ExceptionInterceptor> exceptionInterceptors = new ArrayList<ExceptionInterceptor>();
    private List<FinallyInterceptor> finallyInterceptors = new ArrayList<FinallyInterceptor>();
    final RequestHandlerProxy.GroupInterceptorWithResult BEFORE_INTERCEPTOR = new RequestHandlerProxy.GroupInterceptorWithResult(this.beforeInterceptors);
    final RequestHandlerProxy.GroupAfterInterceptor AFTER_INTERCEPTOR = new RequestHandlerProxy.GroupAfterInterceptor(this.afterInterceptors);
    final RequestHandlerProxy.GroupFinallyInterceptor FINALLY_INTERCEPTOR = new RequestHandlerProxy.GroupFinallyInterceptor(this.finallyInterceptors);
    final RequestHandlerProxy.GroupExceptionInterceptor EXCEPTION_INTERCEPTOR = new RequestHandlerProxy.GroupExceptionInterceptor(this.exceptionInterceptors);

    AppInterceptorManager(App app) {
        super(app);
    }

    public Result handleBefore(ActionContext actionContext) throws Exception {
        return this.BEFORE_INTERCEPTOR.apply(actionContext);
    }

    public Result handleAfter(Result result, ActionContext actionContext) throws Exception {
        return this.AFTER_INTERCEPTOR.apply(result, actionContext);
    }

    public void handleFinally(ActionContext actionContext) throws Exception {
        this.FINALLY_INTERCEPTOR.apply(actionContext);
    }

    public Result handleException(Exception ex, ActionContext actionContext) throws Exception {
        return this.EXCEPTION_INTERCEPTOR.apply(ex, actionContext);
    }

    public void registerInterceptor(BeforeInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.beforeInterceptors, interceptor);
    }

    public void registerInterceptor(AfterInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.afterInterceptors, interceptor);
    }

    public void registerInterceptor(FinallyInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.finallyInterceptors, interceptor);
    }

    public void registerInterceptor(ExceptionInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.exceptionInterceptors, interceptor);
        Collections.sort(this.exceptionInterceptors);
    }

    @Override
    protected void releaseResources() {
        this.beforeInterceptors.clear();
        this.afterInterceptors.clear();
        this.exceptionInterceptors.clear();
        this.finallyInterceptors.clear();
    }
}

