/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.app.ProjectLayout;
import act.app.ProjectLayoutProbe;
import act.plugin.Plugin;
import java.io.File;
import java.util.List;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.IO;

public class BuildFileProbe
extends ProjectLayoutProbe {
    private String buildFileName;
    private FileParser fileParser = null;
    private StringParser stringParser = null;
    private LinesParser linesParser = null;

    public BuildFileProbe(FileParser fp) {
        this.buildFileName = fp.buildFileName();
        this.fileParser = fp;
    }

    public BuildFileProbe(StringParser sp) {
        this.buildFileName = sp.buildFileName();
        this.stringParser = sp;
    }

    public BuildFileProbe(LinesParser lp) {
        this.buildFileName = lp.buildFileName();
        this.linesParser = lp;
    }

    public String buildFileName() {
        return this.buildFileName;
    }

    @Override
    public ProjectLayout probe(File appBase) {
        File buildFile = new File(appBase, this.buildFileName);
        if (buildFile.exists() && buildFile.canRead()) {
            if (null != this.fileParser) {
                return this.fileParser.parse(buildFile);
            }
            if (null != this.stringParser) {
                return this.stringParser.parse(IO.readContentAsString((File)buildFile));
            }
            if (null != this.linesParser) {
                return this.linesParser.parse(IO.readLines((File)buildFile));
            }
            assert (false);
        }
        return null;
    }

    public static abstract class LinesParser
    extends Lang.F1<List<String>, ProjectLayout>
    implements BuildFileNameProvider,
    Plugin {
        public ProjectLayout apply(List<String> lines) throws NotAppliedException, Lang.Break {
            return this.parse(lines);
        }

        @Override
        public void register() {
            Act.mode().appScanner().register(new BuildFileProbe(this));
        }

        protected abstract ProjectLayout parse(List<String> var1);
    }

    public static abstract class StringParser
    extends Lang.F1<String, ProjectLayout>
    implements BuildFileNameProvider,
    Plugin {
        public ProjectLayout apply(String s) throws NotAppliedException, Lang.Break {
            return this.parse(s);
        }

        @Override
        public void register() {
            Act.mode().appScanner().register(new BuildFileProbe(this));
        }

        protected abstract ProjectLayout parse(String var1);
    }

    public static abstract class FileParser
    extends Lang.F1<File, ProjectLayout>
    implements BuildFileNameProvider,
    Plugin {
        public ProjectLayout apply(File file) throws NotAppliedException, Lang.Break {
            return this.parse(file);
        }

        @Override
        public void register() {
            Act.mode().appScanner().register(new BuildFileProbe(this));
        }

        protected abstract ProjectLayout parse(File var1);
    }

    public static interface BuildFileNameProvider {
        public String buildFileName();
    }
}

