/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.app.DaoLocator;
import act.app.event.SysEventId;
import act.conf.AppConfig;
import act.db.DB;
import act.db.Dao;
import act.db.DbManager;
import act.db.DbPlugin;
import act.db.DbService;
import act.db.DbServiceInitialized;
import act.db.EntityClassRepository;
import act.db.util.SequenceNumberGenerator;
import act.db.util._SequenceNumberGenerator;
import act.event.ActEventListenerBase;
import act.event.EventBus;
import act.event.SysEventListenerBase;
import act.util.ClassNode;
import act.util.General;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.ConfigurationException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

@ApplicationScoped
public class DbServiceManager
extends AppServiceBase<DbServiceManager>
implements DaoLocator {
    private static Logger logger = LogManager.get(DbServiceManager.class);
    public static final String DEFAULT = "default";
    private Map<String, DbService> serviceMap = new HashMap<String, DbService>();
    private Map<Class<?>, Dao> modelDaoMap = new HashMap();
    private final Dictionary<DbService, DbService> asyncInitializers = new Hashtable<DbService, DbService>();
    private String firstInstance = "default";

    @Inject
    public DbServiceManager(final App app) {
        super(app);
        EntityClassRepository.init(app);
        this.initServices(app.config());
        this.prepareAsyncInitializers();
        this.configureSequenceGenerator(app);
        final Runnable daoInitializer = new Runnable(){

            @Override
            public void run() {
                ClassNode node = app.classLoader().classInfoRepository().node(Dao.class.getName());
                node.visitPublicNotAbstractTreeNodes(new Lang.Visitor<ClassNode>(){

                    private boolean isGeneral(Class c) {
                        Annotation[] aa;
                        for (Annotation a : aa = c.getDeclaredAnnotations()) {
                            if (!(a instanceof General)) continue;
                            return true;
                        }
                        return false;
                    }

                    public void visit(ClassNode classNode) throws Lang.Break {
                        Class daoType = $.classForName((String)classNode.name(), (ClassLoader)app.classLoader());
                        if (this.isGeneral(daoType)) {
                            return;
                        }
                        try {
                            Dao dao = (Dao)$.cast(app.getInstance(daoType));
                            Class modelType = dao.modelType();
                            DB db = modelType.getAnnotation(DB.class);
                            String svcId = null == db ? DbServiceManager.DEFAULT : db.value();
                            Object dbService = DbServiceManager.this.dbService(svcId);
                            E.invalidConfigurationIf((null == dbService ? 1 : 0) != 0, (String)"cannot find db service by id: %s", (Object[])new Object[]{svcId});
                            dao = ((DbService)dbService).newDaoInstance(daoType);
                            DbServiceManager.this.modelDaoMap.put(modelType, dao);
                        }
                        catch (Exception e) {
                            logger.warn((Throwable)e, "error loading DAO: %s", new Object[]{daoType});
                        }
                    }
                });
            }
        };
        EventBus eventBus = app.eventBus();
        if (this.asyncInitializers.isEmpty()) {
            eventBus.bind(SysEventId.SINGLETON_PROVISIONED, new SysEventListenerBase(){

                @Override
                public void on(EventObject event) throws Exception {
                    daoInitializer.run();
                    app.emit(SysEventId.DB_SVC_LOADED);
                }
            });
        } else {
            eventBus.bind(DbServiceInitialized.class, new ActEventListenerBase<DbServiceInitialized>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void on(DbServiceInitialized event) {
                    Dictionary dictionary = DbServiceManager.this.asyncInitializers;
                    synchronized (dictionary) {
                        DbServiceManager.this.asyncInitializers.remove(event.source());
                        if (DbServiceManager.this.asyncInitializers.isEmpty()) {
                            daoInitializer.run();
                            app.emit(SysEventId.DB_SVC_LOADED);
                        }
                    }
                }
            });
        }
    }

    boolean hasDbService() {
        return !this.serviceMap.isEmpty();
    }

    private void configureSequenceGenerator(final App app) {
        app.jobManager().on(SysEventId.DEPENDENCY_INJECTOR_PROVISIONED, new Runnable(){

            @Override
            public void run() {
                _SequenceNumberGenerator seqGen = app.config().sequenceNumberGenerator();
                SequenceNumberGenerator.registerImpl(seqGen);
            }
        });
    }

    private void prepareAsyncInitializers() {
        for (Map.Entry<String, DbService> entry : this.serviceMap.entrySet()) {
            DbService service = entry.getValue();
            if (!service.initAsynchronously()) continue;
            this.asyncInitializers.put(service, service);
        }
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(C.newSet(this.serviceMap.values()), ApplicationScoped.class);
        this.serviceMap.clear();
        Destroyable.Util.tryDestroyAll(C.newSet(this.modelDaoMap.values()), ApplicationScoped.class);
        this.modelDaoMap.clear();
        this.firstInstance = DEFAULT;
    }

    @Override
    public Dao dao(Class<?> modelClass) {
        Dao dao = this.modelDaoMap.get(modelClass);
        if (null == dao) {
            String svcId = DbServiceManager.dbId(modelClass);
            Object dbService = this.dbService(svcId);
            dao = ((DbService)dbService).defaultDao(modelClass);
            this.modelDaoMap.put(modelClass, dao);
        }
        return dao;
    }

    public <T extends DbService> T dbService(String id) {
        return (T)this.serviceMap.get(id);
    }

    public <T extends DbService> List<T> dbServicesByClass(Class<T> dbServiceClass) {
        HashSet<DbService> set = new HashSet<DbService>();
        for (DbService service : this.serviceMap.values()) {
            if (!dbServiceClass.isInstance(service)) continue;
            set.add(service);
        }
        return new ArrayList(set);
    }

    public Iterable<DbService> registeredServices() {
        return this.serviceMap.values();
    }

    private void initServices(AppConfig config) {
        DbManager dbManager = Act.dbManager();
        if (!dbManager.hasPlugin()) {
            logger.warn("DB service not initialized: No DB plugin found");
            return;
        }
        DbPlugin db = dbManager.theSolePlugin();
        Map<String, Object> dbConf = config.subSet("db.");
        if (dbConf.isEmpty()) {
            if (null == db) {
                logger.warn("DB service not initialized: need to specify default db service implementation");
                return;
            }
            logger.warn("DB configuration not found. Will try to init default service with the sole db plugin: %s", new Object[]{db});
            DbService svc = db.initDbService(DEFAULT, this.app(), new HashMap<String, String>());
            this.serviceMap.put(DEFAULT, svc);
            return;
        }
        if (dbConf.containsKey("db.instances")) {
            String[] sa;
            String instances = ((String)dbConf.get("db.instances")).toString();
            for (String dbId : sa = instances.split("[,\\s;:]+")) {
                this.initService(dbId, dbConf);
            }
            this.firstInstance = sa[0];
            this.app().entityMetaInfoRepo().setDefaultAlias(this.firstInstance);
            this.app().service(EntityClassRepository.class).setDefaultAlias(this.firstInstance);
        }
        if (this.serviceMap.containsKey(DEFAULT)) {
            return;
        }
        String dbId = null;
        if (dbConf.containsKey("db.default.impl")) {
            dbId = DEFAULT;
        } else if (dbConf.containsKey("db.impl")) {
            dbId = "";
        }
        if (null != dbId) {
            this.initService(dbId, dbConf);
        } else if (this.serviceMap.size() == 1) {
            DbService svc = this.serviceMap.values().iterator().next();
            this.serviceMap.put(DEFAULT, svc);
            logger.warn("db service configuration not found. Use the sole one db service[%s] as default service", new Object[]{svc.id()});
        } else if (this.serviceMap.isEmpty()) {
            if (null == db) {
                logger.warn("DB service not initialized: need to specify default db service implementation");
            } else {
                logger.warn("DB configuration not found. Will try to init default service with the sole db plugin: %s", new Object[]{db});
                HashMap<String, String> svcConf = new HashMap<String, String>();
                String prefix = "db.";
                for (String key : dbConf.keySet()) {
                    if (!key.startsWith(prefix)) continue;
                    String o = (String)dbConf.get(key);
                    svcConf.put(key.substring(prefix.length()), o);
                }
                DbService svc = db.initDbService(DEFAULT, this.app(), svcConf);
                this.serviceMap.put(DEFAULT, svc);
            }
        } else {
            logger.warn("Default service not specified. Use the first db instance as default service: %s", new Object[]{this.firstInstance});
            this.serviceMap.put(DEFAULT, this.serviceMap.get(this.firstInstance));
        }
    }

    private void initService(String dbId, Map<String, String> conf) {
        String svcId;
        HashMap<String, String> svcConf = new HashMap<String, String>();
        String prefix = "db." + (S.blank((String)dbId) ? "" : dbId + ".");
        for (String key : conf.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String o = conf.get(key);
            svcConf.put(key.substring(prefix.length()), o);
        }
        String impl = (String)svcConf.remove("impl");
        String string = svcId = S.empty((String)dbId) ? DEFAULT : dbId;
        if (null == impl) {
            throw new ConfigurationException("Cannot init db service[%s]: implementation not specified", new Object[]{svcId});
        }
        DbPlugin plugin = Act.dbManager().plugin(impl);
        if (null == plugin) {
            throw new ConfigurationException("Cannot init db service[%s]: implementation not found: %s", new Object[]{svcId, impl});
        }
        DbService svc = plugin.initDbService(S.blank((String)dbId) ? DEFAULT : dbId, this.app(), svcConf);
        this.serviceMap.put(svcId, svc);
        logger.info("db service[%s] initialized", new Object[]{svcId});
    }

    public static String dbId(Class<?> modelClass) {
        DB db = modelClass.getAnnotation(DB.class);
        if (null != db) {
            return db.value();
        }
        return DEFAULT;
    }
}

