/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.app.App;
import act.app.event.SysEventId;
import act.util.AnnotatedClassFinder;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import act.util.InheritedStateless;
import act.util.Lazy;
import act.util.SingletonBase;
import act.util.Stateless;
import act.util.SubClassFinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import javax.inject.Singleton;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.E;

public class SingletonFinder {
    private static final Logger LOGGER = LogManager.get(SingletonFinder.class);

    private SingletonFinder() {
    }

    @SubClassFinder(value=SingletonBase.class)
    @AnnotatedClassFinder(value=Singleton.class)
    public static void found(Class<?> cls) {
        SingletonFinder.registerSingleton(cls);
    }

    @AnnotatedClassFinder(value=Stateless.class, callOn=SysEventId.PRE_START)
    public static void foundStateless(Class<?> cls) {
        SingletonFinder.registerSingleton(cls);
    }

    @AnnotatedClassFinder(value=InheritedStateless.class, callOn=SysEventId.PRE_START, noAbstract=false)
    public static void foundInheritedStateless(Class<?> cls) {
        final App app = App.instance();
        if (!Modifier.isAbstract(cls.getModifiers())) {
            app.registerSingletonClass(cls);
        }
        ClassInfoRepository repo = app.classLoader().classInfoRepository();
        ClassNode node = repo.node(cls.getName());
        node.visitPublicNotAbstractSubTreeNodes(new Lang.Visitor<ClassNode>(){

            public void visit(ClassNode classNode) throws Lang.Break {
                String name = classNode.name();
                Class cls = $.classForName((String)name, (ClassLoader)app.classLoader());
                if (!SingletonFinder.stopInheritedScope(cls)) {
                    SingletonFinder.registerSingleton(cls);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("@Stateful or @StopInheritedScope annotation found on %s, inherited stateless terminated", new Object[]{name});
                }
            }
        });
    }

    private static void registerSingleton(Class<?> cls) {
        E.invalidConfigurationIf((boolean)SingletonFinder.stopInheritedScope(cls), (String)"@Stateful or @StopInheritedScope annotation cannot be apply on singleton or @Stateless annotated class", (Object[])new Object[0]);
        Object instance = SingletonFinder.tryLoadAppService(cls);
        if (null != instance) {
            Act.app().registerSingleton(instance);
        } else if (null == cls.getAnnotation(Lazy.class)) {
            App.instance().registerSingletonClass(cls);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("register singleton: %s", new Object[]{cls});
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("skip lazy singleton registration for %s", new Object[]{cls});
        }
    }

    private static Object tryLoadAppService(Class cls) {
        return Act.app().service(cls);
    }

    private static boolean stopInheritedScope(Class<?> cls) {
        Object injector = Act.app().injector();
        for (Annotation anno : cls.getAnnotations()) {
            if (!injector.isInheritedScopeStopper(anno.annotationType())) continue;
            return true;
        }
        return false;
    }
}

