/*
 * Decompiled with CFR 0.152.
 */
package act.boot.app;

import act.Constants;
import act.boot.BootstrapClassLoader;
import act.util.ActClassLoader;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import act.util.Jars;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.OS;
import org.osgl.util.S;

public class FullStackAppBootstrapClassLoader
extends BootstrapClassLoader
implements ActClassLoader {
    private static final String KEY_CLASSPATH = "java.class.path";
    private static final String KEY_SYS_JAR_IGNORE = "act.jar.sys.ignore";
    private static final String KEY_APP_JAR_IGNORE = "act.jar.app.ignore";
    private static final String DEF_JAR_IGNORE = "act-asm,antlr,ecj-,cglib,commons-,hibernate-,jline-,kryo-,logback-,mongo-java-,mvel,newrelic,okio-,okhttp,pat-,proxytoys,rythm-engine,snakeyaml,undertow,xnio";
    private final Class<?> PLUGIN_CLASS;
    private List<File> jars;
    private Long jarsChecksum;
    private Map<String, byte[]> libBC = new HashMap<String, byte[]>();
    private List<Class<?>> actClasses = new ArrayList();
    private List<Class<?>> pluginClasses = new ArrayList();
    private String lineSeparator = OS.get().lineSeparator();
    private static final Lang.Predicate<File> jarFilter = FullStackAppBootstrapClassLoader.jarFilter();

    public FullStackAppBootstrapClassLoader(ClassLoader parent) {
        super(parent);
        this.preload();
        this.PLUGIN_CLASS = $.classForName((String)"act.plugin.Plugin", (ClassLoader)this);
    }

    @Override
    public List<Class<?>> pluginClasses() {
        if (this.classInfoRepository().isEmpty()) {
            this.restoreClassInfoRegistry();
            this.restorePluginClasses();
            if (this.classInfoRepository.isEmpty()) {
                for (String className : C.list(this.libBC.keySet())) {
                    try {
                        Class<?> c = this.loadClass(className, true);
                        this.cache(c);
                        int modifier = c.getModifiers();
                        if (Modifier.isAbstract(modifier) || !Modifier.isPublic(modifier) || c.isInterface() || !this.PLUGIN_CLASS.isAssignableFrom(c)) continue;
                        this.pluginClasses.add(c);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                }
                this.saveClassInfoRegistry();
                this.savePluginClasses();
            }
        }
        return this.pluginClasses;
    }

    public int libBCSize() {
        return this.libBC.size();
    }

    protected void preload() {
        this.buildIndex();
    }

    protected List<File> jars() {
        if (null == this.jars) {
            this.jars = FullStackAppBootstrapClassLoader.jars(FullStackAppBootstrapClassLoader.class.getClassLoader());
            this.jarsChecksum = FullStackAppBootstrapClassLoader.calculateChecksum(this.jars);
        }
        return this.jars;
    }

    protected long jarsChecksum() {
        this.jars();
        return this.jarsChecksum;
    }

    private static Lang.Predicate<File> jarFilter() {
        String appIgnores;
        String ignores = System.getProperty(KEY_SYS_JAR_IGNORE);
        if (null == ignores) {
            ignores = DEF_JAR_IGNORE;
        }
        if (null != (appIgnores = System.getProperty(KEY_APP_JAR_IGNORE))) {
            ignores = ignores + "," + appIgnores;
        }
        final String[] sa = ignores.split(",");
        return new Lang.Predicate<File>(){

            public boolean test(File file) {
                String name = file.getName();
                for (String prefix : sa) {
                    if (!S.notBlank((String)prefix) || !name.startsWith(prefix)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static List<File> filterJars(List<File> jars) {
        if (null == jarFilter) {
            return null;
        }
        return C.list(jars).filter(jarFilter);
    }

    public static List<File> jars(ClassLoader cl) {
        C.List jars = null;
        C.List path = C.listOf((Object[])System.getProperty(KEY_CLASSPATH).split(File.pathSeparator));
        if (path.size() < 10 && cl instanceof URLClassLoader) {
            URLClassLoader realm = (URLClassLoader)cl;
            C.List urlList = C.listOf((Object[])realm.getURLs());
            urlList = urlList.filter((Lang.Function)new Lang.Predicate<URL>(){

                public boolean test(URL url) {
                    return url.getFile().endsWith(".jar");
                }
            });
            jars = urlList.map((Lang.Function)new Lang.Transformer<URL, File>(){

                public File transform(URL url) {
                    try {
                        return new File(url.toURI());
                    }
                    catch (Exception e) {
                        throw E.unexpected((Throwable)e);
                    }
                }
            }).sorted();
        }
        if (null == jars) {
            path = path.filter((Lang.Function)S.F.contains((String)("jre" + File.separator + "lib")).negate().and(new Lang.Function[]{S.F.endsWith((String)".jar")}));
            jars = path.map((Lang.Function)new Lang.Transformer<String, File>(){

                public File transform(String s) {
                    return new File(s);
                }
            }).sorted();
        }
        return FullStackAppBootstrapClassLoader.filterJars(jars);
    }

    private void saveClassInfoRegistry() {
        this.saveToFile(".act.class-registry", this.classInfoRepository().toJSON());
    }

    private void savePluginClasses() {
        if (this.pluginClasses.isEmpty()) {
            return;
        }
        StringBuilder sb = S.builder();
        for (Class<?> c : this.pluginClasses) {
            sb.append(c.getName()).append(this.lineSeparator);
        }
        sb.deleteCharAt(sb.length() - 1);
        this.saveToFile(".act.plugins", sb.toString());
    }

    private void saveToFile(String name, String content) {
        File file = new File(name);
        String fileContent = S.concat((String)"#", (String)S.string((Object)this.jarsChecksum), (String)this.lineSeparator, (String)content);
        IO.writeContent((CharSequence)fileContent, (File)file);
    }

    private void restoreClassInfoRegistry() {
        List<String> list = this.restoreFromFile(".act.class-registry");
        if (list.isEmpty()) {
            return;
        }
        String json = S.join((String)this.lineSeparator, list);
        this.classInfoRepository = ClassInfoRepository.parseJSON(json);
    }

    private void restorePluginClasses() {
        List<String> list = this.restoreFromFile(".act.plugins");
        if (list.isEmpty()) {
            return;
        }
        for (String s : list) {
            this.pluginClasses.add($.classForName((String)s, (ClassLoader)this));
        }
    }

    private List<String> restoreFromFile(String name) {
        String content;
        Object[] sa;
        long fileChecksum;
        File file = new File(name);
        if (file.canRead() && this.jarsChecksum.equals(fileChecksum = Long.parseLong((sa = (content = IO.readContentAsString((File)file)).split(this.lineSeparator))[0].substring(1)))) {
            return C.listOf((Object[])sa).drop(1);
        }
        return C.list();
    }

    private synchronized ClassNode cache(Class<?> c) {
        String pcname;
        Class<?>[] ca;
        String cname = ClassInfoRepository.canonicalName(c);
        if (null == cname) {
            return null;
        }
        String name = c.getName();
        ClassInfoRepository repo = this.classInfoRepository();
        if (repo.has(cname)) {
            return repo.node(name, cname);
        }
        this.actClasses.add(c);
        ClassNode node = repo.node(name);
        node.modifiers(c.getModifiers());
        for (Class<?> pc : ca = c.getInterfaces()) {
            String pcname2;
            if (pc == Object.class || null == (pcname2 = ClassInfoRepository.canonicalName(pc))) continue;
            this.cache(pc);
            node.addInterface(pcname2);
        }
        Class<?> pc = c.getSuperclass();
        if (null != pc && Object.class != pc && null != (pcname = ClassInfoRepository.canonicalName(pc))) {
            this.cache(pc);
            node.parent(pcname);
        }
        return node;
    }

    private void buildIndex() {
        this.libBC.putAll(Jars.buildClassNameIndex(this.jars()));
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (null != c) {
            return c;
        }
        if (name.startsWith("java") || name.startsWith("org.osgl") || name.startsWith("org.slf4j")) {
            return super.loadClass(name, resolve);
        }
        if (!protectedClasses.contains(name)) {
            c = this.loadActClass(name, resolve);
        }
        if (null == c) {
            return super.loadClass(name, resolve);
        }
        return c;
    }

    protected byte[] tryLoadResource(String name) {
        return null;
    }

    protected Class<?> loadActClass(String name, boolean resolve) {
        byte[] ba = this.libBC.remove(name);
        if (null == ba) {
            ba = this.tryLoadResource(name);
        }
        if (null == ba) {
            return this.findLoadedClass(name);
        }
        Class<?> c = null;
        if (name.startsWith(Constants.ACT_PKG) || name.startsWith(Constants.ASM_PKG)) {
            try {
                c = super.defineClass(name, ba, 0, ba.length, DOMAIN);
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
        }
        if (null == c) {
            c = this.defineClass(name, ba);
        }
        if (resolve) {
            super.resolveClass(c);
        }
        return c;
    }

    public Class<?> createClass(String name, byte[] b) throws ClassFormatError {
        return super.defineClass(name, b, 0, b.length, DOMAIN);
    }

    public static long calculateChecksum(List<File> files) {
        long l = 0L;
        for (File file : files) {
            l += (long)file.hashCode() + file.lastModified();
        }
        return l;
    }
}

