/*
 * Decompiled with CFR 0.152.
 */
package act.cli;

import act.Act;
import act.app.App;
import act.app.AppServiceBase;
import act.cli.builtin.Exit;
import act.cli.builtin.Help;
import act.cli.builtin.IterateCursor;
import act.cli.meta.CommandMethodMetaInfo;
import act.cli.meta.CommanderClassMetaInfo;
import act.handler.CliHandler;
import act.handler.builtin.cli.CliHandlerProxy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.Lang;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class CliDispatcher
extends AppServiceBase<CliDispatcher> {
    private static Logger logger = LogManager.get(CliDispatcher.class);
    private static final String NAME_PART_SEPARATOR = "[\\.\\-_]+";
    private Map<String, CliHandler> registry = new HashMap<String, CliHandler>();
    private Map<String, String> shortCuts = new HashMap<String, String>();
    private Map<String, List<CliHandler>> ambiguousShortCuts = new HashMap<String, List<CliHandler>>();
    private Map<CliHandler, List<String>> nameMap = new HashMap<CliHandler, List<String>>();
    private Map<CliHandler, List<String>> shortCutMap = new HashMap<CliHandler, List<String>>();

    public CliDispatcher(App app) {
        super(app);
        this.registerBuiltInHandlers();
    }

    public CliDispatcher registerCommandHandler(String command, CommandMethodMetaInfo methodMetaInfo, CommanderClassMetaInfo classMetaInfo) {
        String[] sa;
        for (String s : sa = command.split("[,;:\\s]+")) {
            if (this.registry.containsKey(s)) {
                throw E.invalidConfiguration((String)"Command %s already registered", (Object[])new Object[]{command});
            }
            this.addToRegistry(s, new CliHandlerProxy(classMetaInfo, methodMetaInfo, this.app()));
            logger.debug("Command registered: %s", new Object[]{s});
        }
        return this;
    }

    public boolean registered(String command) {
        return this.registry.containsKey(command);
    }

    public CliHandler handler(String command) {
        CliHandler handler;
        String command0 = command;
        if (null == (command = this.shortCuts.get(command))) {
            command = command0;
        }
        if (null == (handler = this.registry.get(command)) && !command.startsWith("act.")) {
            handler = this.registry.get("act." + command);
        }
        Act.Mode mode = Act.mode();
        if (null != handler && handler.appliedIn(mode)) {
            return handler;
        }
        return null;
    }

    public List<String> systemCommands() {
        return this.commands(true, false);
    }

    public List<String> applicationCommands() {
        return this.commands(false, true);
    }

    public List<String> commands(boolean sys, boolean app) {
        C.List list = C.newList();
        Act.Mode mode = Act.mode();
        boolean all = !sys && !app;
        for (String s : this.registry.keySet()) {
            CliHandler h;
            boolean isSysCmd = s.startsWith("act.");
            if (isSysCmd && !sys && !all || !isSysCmd && !app && !all || !(h = this.registry.get(s)).appliedIn(mode)) continue;
            list.add((Object)s);
        }
        return list.sorted((Comparator)new Lang.Comparator<String>(){

            public int compare(String o1, String o2) {
                boolean b2;
                boolean b1 = o1.startsWith("act.");
                if (b1 & !(b2 = o2.startsWith("act."))) {
                    return -1;
                }
                if (!b1 & b2) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
    }

    public List<String> names(CliHandler handler) {
        return this.nameMap.get(handler);
    }

    public List<String> shortCuts(CliHandler handler) {
        return this.shortCutMap.get(handler);
    }

    @Override
    protected void releaseResources() {
        this.registry.clear();
    }

    private void addToRegistry(String name, CliHandler handler) {
        this.registry.put(name, handler);
        Help.updateMaxWidth(name.length());
        this.updateNameIndex(name, handler);
        this.registerShortCut(name, handler);
    }

    private void updateNameIndex(String name, CliHandler handler) {
        List<String> nameList = this.nameMap.get(handler);
        if (null == nameList) {
            nameList = new ArrayList<String>();
            this.nameMap.put(handler, nameList);
        }
        nameList.add(name);
    }

    private void registerShortCut(String name, CliHandler handler) {
        List<String> shortCutNames = this.shortCutMap.get(handler);
        if (null == shortCutNames) {
            shortCutNames = new ArrayList<String>();
            this.shortCutMap.put(handler, shortCutNames);
        }
        for (int i = 0; i < 5; ++i) {
            List<CliHandler> list;
            String shortCut = CliDispatcher.shortCut(name, i);
            if (null == shortCut) continue;
            if (this.ambiguousShortCuts.containsKey(shortCut)) {
                list = this.ambiguousShortCuts.get(shortCut);
                list.add(handler);
                continue;
            }
            if (this.shortCuts.containsKey(shortCut)) {
                this.shortCuts.remove(shortCut);
                list = new ArrayList<CliHandler>();
                this.ambiguousShortCuts.put(shortCut, list);
                for (List<String> ls : this.shortCutMap.values()) {
                    ls.remove(shortCut);
                }
                continue;
            }
            this.shortCuts.put(shortCut, name);
            shortCutNames.add(shortCut);
        }
    }

    private static String shortCut(String name, int level) {
        String[] sa = name.split(NAME_PART_SEPARATOR);
        if (sa.length < 2) {
            return null;
        }
        S.Buffer sb = S.buffer();
        switch (level) {
            case 0: {
                sb.append(".");
                for (String s : sa) {
                    sb.append(s.charAt(0));
                }
                return sb.toString();
            }
            case 1: {
                for (String s : sa) {
                    sb.append(s.charAt(0)).append(".");
                }
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
            case 2: {
                for (int i = 0; i < sa.length - 1; ++i) {
                    sb.append(sa[i].charAt(0)).append(".");
                }
                sb.append(sa[sa.length - 1]);
                return sb.toString();
            }
            case 3: {
                for (int i = 0; i < sa.length - 2; ++i) {
                    sb.append(sa[i].charAt(0)).append(".");
                }
                sb.append(sa[sa.length - 2]).append(".");
                sb.append(sa[sa.length - 1].charAt(0));
                return sb.toString();
            }
            case 4: {
                for (String s : sa) {
                    sb.append(s.charAt(0));
                    if (s.length() > 1) {
                        sb.append(s.charAt(1));
                    }
                    sb.append(".");
                }
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
        }
        throw E.unsupport();
    }

    private void registerBuiltInHandlers() {
        this.addToRegistry("act.exit", Exit.INSTANCE);
        this.addToRegistry("act.quit", Exit.INSTANCE);
        this.addToRegistry("act.bye", Exit.INSTANCE);
        this.addToRegistry("act.help", Help.INSTANCE);
        this.addToRegistry("act.it", IterateCursor.INSTANCE);
    }
}

