/*
 * Decompiled with CFR 0.152.
 */
package act.cli;

import act.Destroyable;
import act.app.ActionContext;
import act.app.App;
import act.app.CliServer;
import act.cli.CliContext;
import act.cli.CommandNameCompleter;
import act.cli.builtin.IterateCursor;
import act.cli.event.CliSessionStart;
import act.cli.event.CliSessionTerminate;
import act.cli.util.CliCursor;
import act.handler.CliHandler;
import act.util.Banner;
import act.util.DestroyableBase;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.IO;
import org.osgl.util.S;

public class CliSession
extends DestroyableBase
implements Runnable {
    private String id;
    private CliServer server;
    protected App app;
    private Socket socket;
    private long ts;
    private boolean exit;
    private Thread runningThread;
    private ConsoleReader console;
    private CliCursor cursor;
    private CommandNameCompleter commandNameCompleter;
    private CliHandler handler;
    private boolean daemon;
    private CliContext cliContext;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    protected CliSession(ActionContext context) {
        this.app = context.app();
        this.id = context.session().id();
        this.ts = $.ms();
    }

    public CliSession(Socket socket, CliServer server) {
        this.socket = (Socket)$.NPE((Object)socket);
        this.server = (CliServer)$.NPE((Object)server);
        this.app = server.app();
        this.id = this.app.cuid();
        this.ts = $.ms();
        this.commandNameCompleter = new CommandNameCompleter(this.app);
    }

    public String id() {
        return this.id;
    }

    public CliSession attribute(String key, Object val) {
        this.attributes.put(key, val);
        return this;
    }

    public CliSession removeAttribute(String key) {
        this.attributes.remove(key);
        return this;
    }

    public CliSession dameon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public CliCursor cursor() {
        return this.cursor;
    }

    public CliSession cursor(CliCursor cursor) {
        this.cursor = cursor;
        return this;
    }

    public void removeCursor() {
        this.cursor = null;
    }

    public <T> T attribute(String key) {
        return (T)$.cast((Object)this.attributes.get(key));
    }

    public boolean expired(int expiration) {
        if (this.daemon && null != this.cliContext && !this.cliContext.disconnected()) {
            return false;
        }
        long l = expiration * 1000;
        return l < $.ms() - this.ts;
    }

    @Override
    protected void releaseResources() {
        this.stop();
        this.server = null;
        Destroyable.Util.tryDestroyAll(this.attributes.values(), ApplicationScoped.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.runningThread = Thread.currentThread();
        try {
            this.app.eventBus().emitSync(new CliSessionStart(this), new Object[0]);
            OutputStream os = this.socket.getOutputStream();
            this.console = new ConsoleReader(this.socket.getInputStream(), os);
            String banner = Banner.cachedBanner();
            CliSession.printBanner(banner, this.console);
            String appName = App.instance().name();
            if (S.blank((String)appName)) {
                appName = "act";
            }
            this.console.setPrompt(S.fmt((String)"%s[%s]>", (Object[])new Object[]{appName, this.id}));
            this.console.addCompleter((Completer)this.commandNameCompleter);
            this.console.getTerminal().setEchoEnabled(false);
            while (!this.exit) {
                String line = this.console.readLine();
                if (this.exit) {
                    this.console.println((CharSequence)"session terminated");
                    this.console.flush();
                    return;
                }
                this.ts = $.ms();
                this.app.checkUpdates(true);
                if (S.blank((String)line)) continue;
                try {
                    CliContext context;
                    this.cliContext = context = new CliContext(line, this.app, this.console, this);
                    context.handle();
                }
                catch (Lang.Break b) {
                    Object payload = b.get();
                    if (null == payload) continue;
                    if (payload instanceof Boolean) {
                        this.exit = (Boolean)b.get();
                        continue;
                    }
                    if (payload instanceof String) {
                        this.console.println((CharSequence)((String)payload));
                        continue;
                    }
                    this.console.println((CharSequence)S.fmt((String)"INTERNAL ERROR: unknown payload type: %s", (Object[])new Object[]{payload.getClass()}));
                }
            }
        }
        catch (InterruptedIOException e) {
            this.logger.info("session thread interrupted");
        }
        catch (SocketException e) {
            this.logger.error(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "Error processing cli session");
        }
        finally {
            if (null != this.server) {
                this.server.remove(this);
            }
            IO.close((Closeable)this.socket);
            this.app.eventBus().emitSync(new CliSessionTerminate(this), new Object[0]);
        }
    }

    public void stop() {
        this.exit = true;
        if (null != this.runningThread) {
            this.runningThread.interrupt();
        }
        this.console = null;
        IO.close((Closeable)this.socket);
    }

    public void stop(String message) {
        if (null != this.console) {
            PrintWriter pw = new PrintWriter(this.console.getOutput());
            pw.println(message);
            pw.flush();
        }
        this.stop();
    }

    void handler(CliHandler handler) {
        if (handler == IterateCursor.INSTANCE) {
            return;
        }
        if (null == this.handler || S.string((Object)this.handler).equals(S.string((Object)handler))) {
            this.handler = handler;
            return;
        }
        this.handler = handler;
        this.removeCursor();
    }

    private static void printBanner(String banner, ConsoleReader console) throws IOException {
        String[] lines;
        for (String line : lines = banner.split("[\n\r]")) {
            console.println((CharSequence)line);
        }
    }
}

