/*
 * Decompiled with CFR 0.152.
 */
package act.cli.bytecode;

import act.app.App;
import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.cli.meta.CommandMethodMetaInfo;
import act.cli.meta.CommanderClassMetaInfo;
import act.cli.meta.CommanderClassMetaInfoHolder;
import act.util.AppByteCodeEnhancer;
import java.util.HashSet;
import java.util.Set;
import org.osgl.Lang;

public class CommanderEnhancer
extends AppByteCodeEnhancer<CommanderEnhancer> {
    private String className;
    private CommanderClassMetaInfoHolder infoBase;
    private CommanderClassMetaInfo metaInfo;

    public CommanderEnhancer() {
        super((Lang.Predicate<String>)Lang.F.yes());
    }

    @Override
    protected Class<CommanderEnhancer> subClass() {
        return CommanderEnhancer.class;
    }

    @Override
    protected void reset() {
        this.className = null;
        this.metaInfo = null;
        super.reset();
    }

    @Override
    public AppByteCodeEnhancer app(App app) {
        this.infoBase = app.classLoader();
        return super.app(app);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = Type.getObjectType((String)name).getClassName();
        this.metaInfo = this.infoBase.commanderClassMetaInfo(this.className);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (null == this.metaInfo || CommanderEnhancer.isConstructor(name)) {
            return mv;
        }
        final CommandMethodMetaInfo methodInfo = this.metaInfo.command(name);
        if (null == methodInfo) {
            return mv;
        }
        if (CommanderEnhancer.isPublic(access) && !CommanderEnhancer.isConstructor(name)) {
            return new MethodVisitor(327680, mv){
                private Set<Integer> skipNaming;
                {
                    super(x0, x1);
                    this.skipNaming = new HashSet<Integer>();
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    if ("Ljavax/inject/Named;".equals(desc)) {
                        this.skipNaming.add(parameter);
                    }
                    return super.visitParameterAnnotation(parameter, desc, visible);
                }

                public void visitEnd() {
                    int sz = methodInfo.paramCount();
                    for (int i = 0; i < sz; ++i) {
                        if (this.skipNaming.contains(i)) continue;
                        String name = methodInfo.param(i).name();
                        AnnotationVisitor av = this.mv.visitParameterAnnotation(i, "Ljavax/inject/Named;", true);
                        av.visit("value", (Object)name);
                    }
                    super.visitEnd();
                }
            };
        }
        return mv;
    }
}

