/*
 * Decompiled with CFR 0.152.
 */
package act.cli.meta;

import act.Destroyable;
import act.app.AppClassLoader;
import act.asm.Type;
import act.cli.meta.CommandMethodMetaInfo;
import act.cli.meta.CommanderClassMetaInfoManager;
import act.cli.meta.FieldOptionAnnoInfo;
import act.cli.view.CliView;
import act.sys.meta.SessionVariableAnnoInfo;
import act.util.DestroyableBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.S;

@ApplicationScoped
public class CommanderClassMetaInfo
extends DestroyableBase {
    private static CommanderClassMetaInfo NULL = new CommanderClassMetaInfo(){

        @Override
        protected CommanderClassMetaInfo parent(AppClassLoader classLoader) {
            return this;
        }
    };
    public static final String NAME_SEPARATOR = "[,;:\\s]+";
    private Type type;
    private Type superType;
    private boolean isAbstract = false;
    private List<CommandMethodMetaInfo> commands = new ArrayList<CommandMethodMetaInfo>();
    private Map<String, FieldOptionAnnoInfo> fieldOptionAnnoInfoMap = new HashMap<String, FieldOptionAnnoInfo>();
    private Map<String, SessionVariableAnnoInfo> fieldSessionVariableAnnoInfoMap = new HashMap<String, SessionVariableAnnoInfo>();
    private Map<String, CommandMethodMetaInfo> commandLookup = null;
    private CommanderClassMetaInfo parent;
    private String contextPath;
    private CliView view;

    public CommanderClassMetaInfo className(String name) {
        this.type = Type.getObjectType((String)name);
        return this;
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.destroyAll(this.commands, ApplicationScoped.class);
        this.commands.clear();
        if (null != this.commandLookup) {
            Destroyable.Util.destroyAll(this.commandLookup.values(), ApplicationScoped.class);
            this.commandLookup.clear();
        }
        if (null != this.parent) {
            this.parent.destroy();
        }
        super.releaseResources();
    }

    public boolean isCommander() {
        return !this.commands.isEmpty();
    }

    public String className() {
        return this.type.getClassName();
    }

    public String internalName() {
        return this.type.getInternalName();
    }

    public Type type() {
        return this.type;
    }

    public CommanderClassMetaInfo superType(Type type) {
        this.superType = type;
        return this;
    }

    public CommanderClassMetaInfo view(CliView view) {
        this.view = view;
        return this;
    }

    public CliView view() {
        return this.view;
    }

    public CommanderClassMetaInfo addFieldOptionAnnotationInfo(FieldOptionAnnoInfo info) {
        info.paramName(info.fieldName());
        this.fieldOptionAnnoInfoMap.put(info.fieldName(), info);
        return this;
    }

    public CommanderClassMetaInfo addFieldSessionVariableAnnotInfo(String fieldName, SessionVariableAnnoInfo info) {
        this.fieldSessionVariableAnnoInfoMap.put(fieldName, info);
        return this;
    }

    public FieldOptionAnnoInfo fieldOptionAnnoInfo(String name) {
        FieldOptionAnnoInfo info = this.fieldOptionAnnoInfoMap.get(name);
        if (null == info && null != this.parent) {
            info = this.parent.fieldOptionAnnoInfo(name);
        }
        return info;
    }

    public SessionVariableAnnoInfo fieldSessionVariableAnnoInfo(String name) {
        SessionVariableAnnoInfo info = this.fieldSessionVariableAnnoInfoMap.get(name);
        if (null == info && null != this.parent) {
            info = this.parent.fieldSessionVariableAnnoInfo(name);
        }
        return info;
    }

    public List<FieldOptionAnnoInfo> fieldOptionAnnoInfoList(AppClassLoader appClassLoader) {
        C.List list = C.list(this.fieldOptionAnnoInfoMap.values());
        CommanderClassMetaInfo p = this.parent(appClassLoader);
        if (null != p && NULL != p) {
            list = list.append(p.fieldOptionAnnoInfoList(appClassLoader));
        }
        return list;
    }

    public boolean hasOption(AppClassLoader classLoader) {
        boolean retVal;
        boolean bl = retVal = !this.fieldOptionAnnoInfoMap.isEmpty();
        if (retVal) {
            return true;
        }
        CommanderClassMetaInfo p = this.parent(classLoader);
        if (null != p && NULL != p) {
            return p.hasOption(classLoader);
        }
        return false;
    }

    protected CommanderClassMetaInfo parent(AppClassLoader classLoader) {
        if (null == this.parent) {
            CommanderClassMetaInfoManager manager = classLoader.commanderClassMetaInfoManager();
            this.parent = manager.commanderMetaInfo(this.superType.getClassName());
            if (null == this.parent) {
                this.parent = NULL;
            }
        }
        return this.parent;
    }

    public Type superType() {
        return this.superType;
    }

    public CommanderClassMetaInfo setAbstract() {
        this.isAbstract = true;
        return this;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public CommanderClassMetaInfo addCommand(CommandMethodMetaInfo info) {
        this.commands.add(info);
        return this;
    }

    public CommandMethodMetaInfo command(String name) {
        if (null == this.commandLookup) {
            this.buildCommandLookup();
        }
        return this.commandLookup.get(name);
    }

    public boolean hasCommand() {
        return !this.commands.isEmpty();
    }

    public List<CommandMethodMetaInfo> commandList() {
        return C.list(this.commands);
    }

    public String contextPath() {
        return this.contextPath;
    }

    public CommanderClassMetaInfo contextPath(String path) {
        this.contextPath = S.blank((String)path) ? "/" : path;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CommanderClassMetaInfo) {
            CommanderClassMetaInfo that = (CommanderClassMetaInfo)$.cast((Object)obj);
            return $.eq((Object)that.type, (Object)this.type);
        }
        return false;
    }

    public int hashCode() {
        return $.hc((Object)this.type);
    }

    private void buildCommandLookup() {
        HashMap<String, CommandMethodMetaInfo> lookup = new HashMap<String, CommandMethodMetaInfo>();
        for (CommandMethodMetaInfo command : this.commands) {
            String[] commandNames;
            for (String commandName : commandNames = command.commandName().split(NAME_SEPARATOR)) {
                lookup.put(commandName, command);
            }
            lookup.put(command.methodName(), command);
        }
        this.commandLookup = lookup;
    }
}

