/*
 * Decompiled with CFR 0.152.
 */
package act.cli.meta;

import act.cli.builtin.Help;
import org.osgl.util.E;
import org.osgl.util.S;

public class OptionAnnoInfoBase {
    private String lead1;
    private String lead2;
    private String defVal;
    private String group;
    private String help;
    private boolean required;
    private String param;

    public OptionAnnoInfoBase(boolean optional) {
        this.required = !optional;
    }

    public String toString() {
        return S.fmt((String)"%s %s", (Object[])new Object[]{this.leads(), this.help()});
    }

    public OptionAnnoInfoBase spec(String[] specs) {
        E.illegalArgumentIf((null == specs || specs.length == 0 ? 1 : 0) != 0);
        this.lead1 = specs[0];
        if (specs.length > 1) {
            this.lead2 = specs[1];
        } else {
            String[] sa = this.lead1.split("[,;\\s]+");
            if (sa.length > 2) {
                throw E.unexpected((String)"Option cannot have more than two leads", (Object[])new Object[0]);
            }
            if (sa.length > 1) {
                this.lead1 = sa[0];
                this.lead2 = sa[1];
            }
        }
        Help.updateMaxWidth(this.leads().length());
        return this;
    }

    public String lead1() {
        return this.lead1;
    }

    public String lead2() {
        return this.lead2;
    }

    public String leads() {
        if (null == this.lead1 && null == this.lead2) {
            return "";
        }
        if (null == this.lead1) {
            return this.lead2;
        }
        if (null == this.lead2) {
            return this.lead1;
        }
        return S.join((String)",", (String[])new String[]{this.lead1, this.lead2});
    }

    private void setLeadsIfNotSet(String paramName) {
        if (null == this.lead1) {
            this.lead1 = "-" + paramName.charAt(0);
            this.lead2 = "--" + paramName;
        }
    }

    public OptionAnnoInfoBase required(boolean required) {
        this.required = required;
        return this;
    }

    public boolean required() {
        return this.required;
    }

    public OptionAnnoInfoBase defVal(String defVal) {
        this.defVal = defVal;
        return this;
    }

    public String defVal() {
        return this.defVal;
    }

    public OptionAnnoInfoBase group(String group) {
        this.group = group;
        return this;
    }

    public String group() {
        return this.group;
    }

    public OptionAnnoInfoBase paramName(String name) {
        this.param = name;
        this.setLeadsIfNotSet(name);
        return this;
    }

    public OptionAnnoInfoBase help(String helpMessage) {
        this.help = helpMessage;
        return this;
    }

    public String help() {
        return this.help;
    }
}

