/*
 * Decompiled with CFR 0.152.
 */
package act.cli.util;

import act.cli.InvalidCommandLineException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class CommandLineParser {
    private String command;
    private String raw;
    private Map<String, String> options;
    private List<String> arguments;
    static final Pattern P_QUOTATION = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");
    static final Pattern P_APOSTROPHE = Pattern.compile("([^']\\S*|'.+?')\\s*");

    public CommandLineParser(String line) {
        E.illegalArgumentIf((boolean)S.blank((String)line));
        this.raw = line.trim();
        this.options = new HashMap<String, String>();
        ArrayList<String> sl = new ArrayList<String>();
        Pattern ptn = this.choosePattern(this.raw);
        Matcher m = ptn.matcher(this.raw);
        while (m.find()) {
            String s = m.group(1);
            s = ptn == P_QUOTATION ? S.strip((Object)s, (String)"\"", (String)"\"") : S.strip((Object)s, (String)"'", (String)"'");
            sl.add(s);
        }
        this.parse(sl);
    }

    private Pattern choosePattern(String s) {
        int p2;
        Pattern ptn = P_APOSTROPHE;
        int p1 = s.indexOf(34);
        if (p1 > -1 && ((p2 = s.indexOf(39)) < 0 || p1 < p2)) {
            ptn = P_QUOTATION;
        }
        return ptn;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String commandLine() {
        return this.raw;
    }

    private void parse(List<String> tokens) {
        this.command = tokens.remove(0).intern();
        this.arguments = new ArrayList<String>();
        String lead = null;
        block6: for (String cur : tokens) {
            boolean isNumberic = false;
            try {
                Double.parseDouble(cur);
                isNumberic = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isNumberic && cur.startsWith("-")) {
                String[] sa = cur.split("[=:]");
                switch (sa.length) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.options.put(sa[0], sa[1]);
                        continue block6;
                    }
                    default: {
                        throw new InvalidCommandLineException("uknown option: %s", cur);
                    }
                }
                if (null != lead) {
                    this.options.put(lead, "true");
                }
                lead = cur;
                continue;
            }
            if (null != lead) {
                this.options.put(lead, cur);
                lead = null;
                continue;
            }
            this.arguments.add(cur);
        }
        if (null != lead) {
            this.options.put(lead, "true");
        }
    }

    public String command() {
        return this.command;
    }

    public List<String> arguments() {
        return C.list(this.arguments);
    }

    public String argument(int id) {
        if (id >= this.arguments.size()) {
            return null;
        }
        return this.arguments.get(id);
    }

    public int argumentCount() {
        return this.arguments.size();
    }

    public int optionCount() {
        return this.arguments.size();
    }

    public String argumentAsOption() {
        if (1 == this.argumentCount() && 0 == this.options.size()) {
            return this.argument(0);
        }
        return null;
    }

    public boolean getBoolean(String lead1, String lead2) {
        String s = this.o(lead1, lead2);
        return "true" == s;
    }

    public Boolean getBooleanObject(String lead1, String lead2) {
        return this.getBoolean(lead1, lead2);
    }

    public byte getByte(String lead1, String lead2, Byte def) {
        Byte b = this.getByteObject(lead1, lead2, def);
        if (null != b) {
            return b;
        }
        throw new InvalidCommandLineException("Cannot get byte type option");
    }

    public Byte getByteObject(String lead1, String lead2, Byte def) {
        String s = this.o(lead1, lead2);
        return null == s ? def : Byte.valueOf(s);
    }

    public char getChar(String lead1, String lead2, Character def) {
        Character c = this.getCharObject(lead1, lead2, def);
        if (null != c) {
            return c.charValue();
        }
        throw new InvalidCommandLineException("Cannot get char type option");
    }

    public Character getCharObject(String lead1, String lead2, Character def) {
        String s = this.o(lead1, lead2);
        return Character.valueOf(null == s ? def.charValue() : s.charAt(0));
    }

    public short getShort(String lead1, String lead2, Short def) {
        Short o = this.getShortObject(lead1, lead2, def);
        if (null != o) {
            return o;
        }
        throw new InvalidCommandLineException("Cannot get short type option");
    }

    public Short getShortObject(String lead1, String lead2, Short def) {
        String s = this.o(lead1, lead2);
        return null == s ? def : Short.valueOf(s);
    }

    public int getInt(String lead1, String lead2, Integer def) {
        Integer n = this.getIntObject(lead1, lead2, def);
        if (null != n) {
            return n;
        }
        throw new InvalidCommandLineException("Cannot get int type option");
    }

    public Integer getIntObject(String lead1, String lead2, Integer def) {
        String s = this.o(lead1, lead2);
        return null == s ? def : Integer.valueOf(s);
    }

    public float getFloat(String lead1, String lead2, Float def) {
        Float o = this.getFloatObject(lead1, lead2, def);
        if (null != o) {
            return o.floatValue();
        }
        throw new InvalidCommandLineException("Cannot get float type option");
    }

    public Float getFloatObject(String lead1, String lead2, Float def) {
        String s = this.o(lead1, lead2);
        return null == s ? def : Float.valueOf(s);
    }

    public long getLong(String lead1, String lead2, Long def) {
        Long o = this.getLongObject(lead1, lead2, def);
        if (null != o) {
            return o;
        }
        throw new InvalidCommandLineException("Cannot get long type option");
    }

    public Double getDoubleObject(String lead1, String lead2, Double def) {
        String s = this.o(lead1, lead2);
        return null == s ? def : Double.valueOf(s);
    }

    public double getDouble(String lead1, String lead2, Double def) {
        Double o = this.getDoubleObject(lead1, lead2, def);
        if (null != o) {
            return o;
        }
        throw new InvalidCommandLineException("Cannot get double type option");
    }

    public Long getLongObject(String lead1, String lead2, Long def) {
        String s = this.o(lead1, lead2);
        return null == s ? def : Long.valueOf(s);
    }

    public String getString(String lead1, String lead2) {
        return this.o(lead1, lead2);
    }

    private String o(String lead1, String lead2) {
        String s = this.options.get(lead1);
        return null == s ? this.options.get(lead2) : s;
    }
}

