/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.Act;
import act.conf.AppConfigKey;
import act.conf.ConfigKey;
import act.conf.ConfigKeyHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.S;

public enum ActConfigKey implements ConfigKey
{
    HOME("home.dir"),
    APP_BASE("app.base", "apps"),
    MODE("mode", (Object)((Object)Act.Mode.PROD)),
    XIO_MAX_WORKER_THREADS("xio.worker_threads.max.int"),
    XIO_STATISTICS("xio.statistics.enabled"),
    NETWORK_SERVER_IMPL("xio.impl");

    private static Logger logger;
    private static ConfigKeyHelper helper;
    private String key;
    private Object defVal;
    private static Map<String, ActConfigKey> lookup;

    private ActConfigKey(String key) {
        this(key, null);
    }

    private ActConfigKey(String key, Object defVal) {
        this.key = key;
        this.defVal = defVal;
    }

    @Override
    public String key() {
        return this.key;
    }

    protected Object getDefVal(Map<String, ?> configuration) {
        return this.defVal;
    }

    public String toString() {
        return this.key;
    }

    @Override
    public Object defVal() {
        return this.defVal;
    }

    @Override
    public <T> List<T> implList(String key, Map<String, ?> configuration, Class<T> c) {
        return helper.getImplList(key, configuration, c);
    }

    @Override
    public <T> T val(Map<String, ?> configuration) {
        return helper.getConfiguration(this, configuration);
    }

    public static ActConfigKey valueOfIgnoreCase(String s) {
        if (S.empty((String)s)) {
            throw new IllegalArgumentException();
        }
        return lookup.get(s.trim().toUpperCase());
    }

    static {
        logger = L.get(AppConfigKey.class);
        helper = new ConfigKeyHelper(Act.F.MODE_ACCESSOR, Act.class.getClassLoader());
        lookup = new HashMap<String, ActConfigKey>(50);
        for (ActConfigKey k : ActConfigKey.values()) {
            lookup.put(k.key().toUpperCase(), k);
        }
    }
}

