/*
 * Decompiled with CFR 0.152.
 */
package act.controller;

import act.ActResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class OutputStreamCache
extends OutputStream {
    private ByteArrayOutputStream tee = new ByteArrayOutputStream();
    private OutputStream out;
    private ByteBuffer buffer;

    public OutputStreamCache(OutputStream os) {
        this.out = os;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.tee.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.tee.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.tee.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        byte[] ba = this.tee.toByteArray();
        ByteBuffer buffer = ByteBuffer.allocateDirect(ba.length);
        buffer.put(ba);
        buffer.flip();
        this.buffer = buffer;
        this.out.close();
    }

    void apply(ActResponse resp) {
        resp.writeContent(this.buffer.duplicate());
    }
}

