/*
 * Decompiled with CFR 0.152.
 */
package act.controller.builtin;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.app.event.SysEventId;
import javax.inject.Singleton;
import org.osgl.cache.CacheService;
import org.osgl.http.H;
import org.osgl.inject.annotation.Configuration;
import org.osgl.mvc.result.Result;
import org.osgl.mvc.result.TooManyRequests;
import org.osgl.util.E;
import org.osgl.util.S;

@Singleton
public class ThrottleFilter {
    public static final String CACHE_NAME = "act.throttle";
    private CacheService cache;
    @Configuration(value="act.req.throttle")
    private int throttle;
    @Configuration(value="req.throttle.expire.scale.enabled")
    private boolean expireScale;

    public ThrottleFilter() {
        final App app = Act.app();
        app.jobManager().on(SysEventId.CLASS_LOADER_INITIALIZED, new Runnable(){

            @Override
            public void run() {
                ThrottleFilter.this.cache = app.cache(ThrottleFilter.CACHE_NAME);
            }
        }, true);
    }

    public ThrottleFilter(int throttle, boolean expireScale) {
        E.illegalArgumentIf((throttle < 1 ? 1 : 0) != 0);
        this.throttle = throttle;
        this.expireScale = expireScale;
        final App app = Act.app();
        app.jobManager().on(SysEventId.CLASS_LOADER_INITIALIZED, new Runnable(){

            @Override
            public void run() {
                ThrottleFilter.this.cache = app.cache(ThrottleFilter.CACHE_NAME);
            }
        }, true);
    }

    public Result handle(ActionContext actionContext) {
        String key = this.cacheKey(actionContext);
        if (!this.expireScale) {
            if (this.throttle <= this.cache.incr(key, 1)) {
                return TooManyRequests.get();
            }
        } else {
            Integer curReqCnt = (Integer)this.cache.get(key);
            if (null == curReqCnt) {
                curReqCnt = 0;
            }
            int timeout = curReqCnt + 1;
            this.cache.incr(key, timeout);
            if (curReqCnt >= this.throttle) {
                return TooManyRequests.get();
            }
        }
        return null;
    }

    private String cacheKey(ActionContext context) {
        H.Request req = context.req();
        return S.concat((Object)req.method(), (Object)req.url(), (Object)req.ip());
    }
}

