/*
 * Decompiled with CFR 0.152.
 */
package act.controller.bytecode;

import act.app.ActionContext;
import act.asm.AnnotationVisitor;
import act.asm.AsmContext;
import act.asm.Label;
import act.asm.MethodVisitor;
import act.asm.Opcodes;
import act.asm.Type;
import act.asm.tree.AbstractInsnNode;
import act.asm.tree.FieldInsnNode;
import act.asm.tree.InsnList;
import act.asm.tree.InsnNode;
import act.asm.tree.LabelNode;
import act.asm.tree.LdcInsnNode;
import act.asm.tree.LineNumberNode;
import act.asm.tree.MethodInsnNode;
import act.asm.tree.MethodNode;
import act.asm.tree.VarInsnNode;
import act.controller.bytecode.ResultClassLookup;
import act.controller.meta.HandlerMethodMetaInfo;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.LocalVariableMetaInfo;
import act.util.AsmTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class HandlerEnhancer
extends MethodVisitor
implements Opcodes {
    private static final Logger logger = LogManager.get(HandlerEnhancer.class);
    private static final String RESULT_CLASS = Result.class.getName();
    private HandlerMethodMetaInfo info;
    private MethodVisitor next;
    private int paramIdShift = 0;
    private Set<Integer> skipNaming = new HashSet<Integer>();
    private boolean notAction;
    private static final String GET_ACTION_CTX_DESC = "()" + AsmTypes.ACTION_CONTEXT_DESC;
    private static final String RENDER_NM = "renderArg";
    private static final String RENDER_DESC = AsmTypes.methodDesc(ActionContext.class, String.class, Object.class);
    private static final String TEMPLATE_LITERAL_NM = "templateLiteral";
    private static final String TEMPLATE_LITERAL_DESC = AsmTypes.methodDesc(ActionContext.class, String.class);
    private static final String RENDER_ARG_NAMES_NM = "__appRenderArgNames";
    private static final String RENDER_ARG_NAMES_DESC = AsmTypes.methodDesc(ActionContext.class, String.class);

    public HandlerEnhancer(MethodVisitor mv, HandlerMethodMetaInfo meta, int access, String name, String desc, String signature, String[] exceptions) {
        super(327680, (MethodVisitor)new MethodNode(access, name, desc, signature, exceptions));
        this.info = meta;
        this.next = mv;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if ("Lact/controller/NotAction;".equals(desc)) {
            this.notAction = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if ("Ljavax/inject/Named;".equals(desc)) {
            this.skipNaming.add(parameter);
        }
        return super.visitParameterAnnotation(parameter, desc, visible);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (!"this".equals(name)) {
            int paramId = index;
            if (!this.info.isStatic()) {
                --paramId;
            }
            if ((paramId -= this.paramIdShift) < this.info.paramCount()) {
                HandlerParamMetaInfo param = this.info.param(paramId);
                param.name(name);
                if (Type.getType(Long.TYPE).equals((Object)param.type()) || Type.getType(Double.TYPE).equals((Object)param.type())) {
                    ++this.paramIdShift;
                }
            }
            LocalVariableMetaInfo local = new LocalVariableMetaInfo(index, name, desc, start, end);
            this.info.addLocal(local);
        }
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        AsmContext.line((int)line);
    }

    public void visitEnd() {
        if (this.notAction) {
            super.visitEnd();
            return;
        }
        MethodNode mn = (MethodNode)this.mv;
        this.addParamAnnotations();
        this.transform(mn);
        mn.accept(this.next);
    }

    private void addParamAnnotations() {
        int sz = this.info.paramCount();
        for (int i = 0; i < sz; ++i) {
            if (this.skipNaming.contains(i)) continue;
            String name = this.info.param(i).name();
            AnnotationVisitor av = this.mv.visitParameterAnnotation(i, "Ljavax/inject/Named;", true);
            av.visit("value", (Object)name);
        }
    }

    private void transform(MethodNode mn) {
        new Transformer(mn, this.info).doIt();
    }

    private static class Transformer {
        MethodNode mn;
        InsnList instructions;
        private HandlerMethodMetaInfo meta;
        List<Label> lblList = C.newSizedList((int)20);

        Transformer(MethodNode mn, HandlerMethodMetaInfo meta) {
            this.mn = mn;
            this.meta = meta;
            this.instructions = this.mergeRenderLineBreaks(mn.instructions);
        }

        void doIt() {
            ListIterator itr = this.instructions.iterator();
            Segment cur = null;
            while (itr.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)itr.next();
                if (insn.getType() == 8) {
                    cur = new Segment(((LabelNode)insn).getLabel(), this.meta, this.instructions, itr, this);
                    continue;
                }
                if (null == cur) continue;
                cur.handle(insn);
            }
        }

        private InsnList mergeRenderLineBreaks(InsnList list) {
            for (AbstractInsnNode insn : list) {
                if (!Transformer.isRenderLine(insn)) continue;
                this.mergeRenderLineBreaks(insn, list);
            }
            return list;
        }

        private void mergeRenderLineBreaks(AbstractInsnNode renderLine, InsnList list) {
            AbstractInsnNode node = renderLine;
            while (null != node) {
                if ((node = node.getPrevious()).getOpcode() == 189) {
                    return;
                }
                if (!(node instanceof LabelNode)) continue;
                AbstractInsnNode node0 = node.getPrevious();
                list.remove(node);
                node = node0;
            }
        }

        static boolean isRenderLine(AbstractInsnNode insnNode) {
            if (!(insnNode instanceof MethodInsnNode)) {
                return false;
            }
            MethodInsnNode node = (MethodInsnNode)insnNode;
            Type type = Type.getMethodType((String)node.desc);
            Type retType = type.getReturnType();
            return Transformer.isResult(retType) && node.desc.startsWith("([Ljava/lang/Object;)");
        }

        static boolean isResult(Type type) {
            return ResultClassLookup.isResult(type.getClassName());
        }

        private static class LoadInsnInfo {
            private String name;
            private InsnList insnList;

            LoadInsnInfo(String name, InsnList insnList) {
                this.insnList = insnList;
                this.name = name;
            }

            void appendTo(InsnList list, S.Buffer paramNames) {
                LdcInsnNode ldc = new LdcInsnNode((Object)this.name);
                list.add((AbstractInsnNode)ldc);
                list.add(this.insnList);
                MethodInsnNode invokeRenderArg = new MethodInsnNode(182, AsmTypes.ACTION_CONTEXT_INTERNAL_NAME, HandlerEnhancer.RENDER_NM, RENDER_DESC, false);
                list.add((AbstractInsnNode)invokeRenderArg);
                if (paramNames.length() != 0) {
                    paramNames.append(',');
                }
                paramNames.append(this.name);
            }

            public String toString() {
                return S.fmt((String)"Load %s", (Object[])new Object[]{this.name});
            }
        }

        private static class InvocationHandler
        extends InstructionHandler {
            InvocationHandler(Segment segment, HandlerMethodMetaInfo meta) {
                super(segment, meta);
            }

            @Override
            protected void handle(AbstractInsnNode node) {
                MethodInsnNode n = (MethodInsnNode)node;
                Type type = Type.getMethodType((String)n.desc);
                Type retType = type.getReturnType();
                if (Transformer.isResult(retType)) {
                    if (n.desc.startsWith("([Ljava/lang/Object;)")) {
                        this.injectRenderArgSetCode((AbstractInsnNode)n);
                    }
                    this.injectThrowCode((AbstractInsnNode)n);
                    this.meta.setThrowRenderResult();
                }
            }

            private String ctxFieldName() {
                return this.segment.meta.classInfo().ctxField();
            }

            private int ctxIndex() {
                return this.segment.meta.appCtxLocalVariableTableIndex();
            }

            private void injectRenderArgSetCode(AbstractInsnNode invokeNode) {
                int len;
                if (!this.segment.meta.hasLocalVariableTable()) {
                    logger.warn("local variable table info not found. ActionContext render args might not be automatically populated");
                }
                AbstractInsnNode node = invokeNode.getPrevious();
                ArrayList<LoadInsnInfo> loadInsnInfoList = new ArrayList<LoadInsnInfo>();
                String templateLiteral = null;
                String renderArgName = null;
                InsnList nodeList = new InsnList();
                boolean invalidParam = false;
                block14: while (null != node) {
                    int type = node.getType();
                    boolean breakWhile = false;
                    block0 : switch (type) {
                        case 8: 
                        case 14: {
                            node = node.getNext();
                            breakWhile = true;
                            if (invalidParam || null == renderArgName) break;
                            loadInsnInfoList.add(new LoadInsnInfo(renderArgName, nodeList));
                            break;
                        }
                        case 0: {
                            switch (node.getOpcode()) {
                                case 89: {
                                    AbstractInsnNode prev = node.getPrevious();
                                    if (187 == prev.getOpcode()) {
                                        logger.warn("Invalid render argument found in %s: new object is not accepted", new Object[]{this.segment.meta.fullName()});
                                        renderArgName = null;
                                        nodeList = new InsnList();
                                        invalidParam = false;
                                        node = prev.getPrevious();
                                        continue block14;
                                    }
                                    if (!invalidParam && null != renderArgName) {
                                        loadInsnInfoList.add(new LoadInsnInfo(renderArgName, nodeList));
                                    }
                                    renderArgName = null;
                                    nodeList = new InsnList();
                                    invalidParam = false;
                                }
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 83: {
                                    break block0;
                                }
                            }
                            logger.warn("Invalid render argument found in %s: unknow opcode: %s", new Object[]{this.segment.meta.fullName(), node.getOpcode()});
                            invalidParam = true;
                            break;
                        }
                        case 3: {
                            if (187 != node.getOpcode()) break;
                            logger.warn("Invalid render argument found in %s: new object is not accepted", new Object[]{this.segment.meta.fullName()});
                            invalidParam = true;
                            break;
                        }
                        case 2: {
                            if (null == renderArgName) {
                                VarInsnNode vn = (VarInsnNode)node;
                                if (0 != vn.var || this.segment.meta.isStatic()) {
                                    renderArgName = this.segment.varName(vn.var);
                                }
                            }
                            nodeList.insert(node.clone((Map)C.Map((Object[])new Object[0])));
                            break;
                        }
                        case 5: {
                            if (invalidParam) break;
                            if (null == renderArgName) {
                                MethodInsnNode mn = (MethodInsnNode)node;
                                if (mn.desc.startsWith("()")) {
                                    renderArgName = mn.name;
                                } else if (!"valueOf".equals(mn.name)) {
                                    logger.warn("Invalid render argument found in %s: method with param is not supported", new Object[]{this.segment.meta.fullName()});
                                    invalidParam = true;
                                }
                            }
                            nodeList.insert(node.clone((Map)C.Map((Object[])new Object[0])));
                            break;
                        }
                        case 1: {
                            if (16 != node.getOpcode()) break;
                            if (!invalidParam && null != renderArgName) {
                                loadInsnInfoList.add(new LoadInsnInfo(renderArgName, nodeList));
                            }
                            renderArgName = null;
                            nodeList = new InsnList();
                            invalidParam = false;
                            break;
                        }
                        case 4: {
                            if (invalidParam) break;
                            if (null == renderArgName) {
                                FieldInsnNode n = (FieldInsnNode)node;
                                renderArgName = n.name;
                            }
                            nodeList.insert(node.clone((Map)C.Map((Object[])new Object[0])));
                            break;
                        }
                        case 9: {
                            if (invalidParam) break;
                            LdcInsnNode ldc = (LdcInsnNode)node;
                            if (null != templateLiteral) {
                                logger.warn("Cannot have more than one template path parameter in the render call. Template path[%s] ignored", new Object[]{templateLiteral});
                                break;
                            }
                            if (!(ldc.cst instanceof String)) {
                                logger.warn("Template path must be strictly String type. Found: %s", new Object[]{ldc.cst});
                                break;
                            }
                            templateLiteral = ldc.cst.toString();
                        }
                    }
                    if (breakWhile) break;
                    node = node.getPrevious();
                }
                InsnList list = new InsnList();
                int appCtxIdx = this.ctxIndex();
                if (null != templateLiteral) {
                    if (appCtxIdx < 0) {
                        String appCtxFieldName = this.ctxFieldName();
                        if (null == appCtxFieldName) {
                            MethodInsnNode getAppCtx = new MethodInsnNode(184, AsmTypes.ACTION_CONTEXT_INTERNAL_NAME, "current", GET_ACTION_CTX_DESC, false);
                            list.add((AbstractInsnNode)getAppCtx);
                        } else {
                            VarInsnNode loadThis = new VarInsnNode(25, 0);
                            FieldInsnNode getCtx = new FieldInsnNode(180, this.segment.meta.classInfo().internalName(), appCtxFieldName, AsmTypes.ACTION_CONTEXT_DESC);
                            list.add((AbstractInsnNode)loadThis);
                            list.add((AbstractInsnNode)getCtx);
                        }
                    } else {
                        LabelNode lbl = new LabelNode();
                        VarInsnNode loadCtx = new VarInsnNode(25, appCtxIdx);
                        list.add((AbstractInsnNode)lbl);
                        list.add((AbstractInsnNode)loadCtx);
                    }
                    LdcInsnNode insnNode = new LdcInsnNode((Object)templateLiteral);
                    list.add((AbstractInsnNode)insnNode);
                    MethodInsnNode invokeTemplatePath = new MethodInsnNode(182, AsmTypes.ACTION_CONTEXT_INTERNAL_NAME, HandlerEnhancer.TEMPLATE_LITERAL_NM, TEMPLATE_LITERAL_DESC, false);
                    list.add((AbstractInsnNode)invokeTemplatePath);
                    InsnNode pop = new InsnNode(87);
                    list.add((AbstractInsnNode)pop);
                }
                if (0 == (len = loadInsnInfoList.size())) {
                    if (list.size() > 0) {
                        this.segment.instructions.insertBefore(node, list);
                    }
                    return;
                }
                if (appCtxIdx < 0) {
                    String appCtxFieldName = this.ctxFieldName();
                    if (null == appCtxFieldName) {
                        MethodInsnNode getActionContext = new MethodInsnNode(184, AsmTypes.ACTION_CONTEXT_INTERNAL_NAME, "current", GET_ACTION_CTX_DESC, false);
                        list.add((AbstractInsnNode)getActionContext);
                    } else {
                        VarInsnNode loadThis = new VarInsnNode(25, 0);
                        FieldInsnNode getCtx = new FieldInsnNode(180, this.segment.meta.classInfo().internalName(), appCtxFieldName, AsmTypes.ACTION_CONTEXT_DESC);
                        list.add((AbstractInsnNode)loadThis);
                        list.add((AbstractInsnNode)getCtx);
                    }
                } else {
                    LabelNode lbl = new LabelNode();
                    VarInsnNode loadCtx = new VarInsnNode(25, appCtxIdx);
                    list.add((AbstractInsnNode)lbl);
                    list.add((AbstractInsnNode)loadCtx);
                }
                S.Buffer sb = S.newBuffer();
                for (int i = 0; i < len; ++i) {
                    LoadInsnInfo info = (LoadInsnInfo)loadInsnInfoList.get(i);
                    info.appendTo(list, sb);
                }
                LdcInsnNode ldc = new LdcInsnNode((Object)sb.toString());
                list.add((AbstractInsnNode)ldc);
                MethodInsnNode invokeRenderArg = new MethodInsnNode(182, AsmTypes.ACTION_CONTEXT_INTERNAL_NAME, HandlerEnhancer.RENDER_ARG_NAMES_NM, RENDER_ARG_NAMES_DESC, false);
                list.add((AbstractInsnNode)invokeRenderArg);
                InsnNode pop = new InsnNode(87);
                list.add((AbstractInsnNode)pop);
                this.segment.instructions.insertBefore(node, list);
            }

            private void injectThrowCode(AbstractInsnNode invokeNode) {
                if (this.segment.meta.hasReturn()) {
                    return;
                }
                AbstractInsnNode next = invokeNode.getNext();
                if (next.getOpcode() == 87) {
                    InsnNode newNext = new InsnNode(191);
                    InsnList instructions = this.segment.instructions;
                    instructions.insert(invokeNode, (AbstractInsnNode)newNext);
                    instructions.remove(next);
                    next = newNext.getNext();
                    int curLine = -1;
                    while (null != next) {
                        boolean breakWhile = false;
                        int type = next.getType();
                        switch (type) {
                            case 8: {
                                next = next.getNext();
                                break;
                            }
                            case 15: {
                                curLine = ((LineNumberNode)next).line;
                                next = next.getNext();
                                break;
                            }
                            case 7: {
                                AbstractInsnNode tmp = next.getNext();
                                instructions.remove(next);
                                next = tmp;
                                break;
                            }
                            case 0: {
                                AbstractInsnNode tmp;
                                int op = next.getOpcode();
                                if (op == 177) {
                                    tmp = next.getNext();
                                    instructions.remove(next);
                                    next = tmp;
                                    tmp = next.getPrevious();
                                    if (tmp.getType() != 15) break;
                                    instructions.remove(tmp);
                                    break;
                                }
                            }
                            case 14: {
                                breakWhile = true;
                                break;
                            }
                            default: {
                                AsmContext.line((int)curLine);
                                E.unexpected((String)"Invalid statement after render result statement at line %s", (Object[])new Object[]{curLine});
                            }
                        }
                        if (!breakWhile) continue;
                        break;
                    }
                    this.refreshIteratorNext();
                }
            }
        }

        private static class Segment {
            Label startLabel;
            InsnList instructions;
            HandlerMethodMetaInfo meta;
            ListIterator<AbstractInsnNode> itr;
            Transformer trans;
            private Map<Integer, InstructionHandler> handlers;

            Segment(Label start, HandlerMethodMetaInfo meta, InsnList instructions, ListIterator<AbstractInsnNode> itr, Transformer trans) {
                this.startLabel = start;
                this.meta = meta;
                this.instructions = instructions;
                this.itr = itr;
                this.trans = trans;
                this.handlers = C.Map((Object[])new Object[]{5, new InvocationHandler(this, meta)});
                trans.lblList.add(start);
            }

            String varName(int index) {
                Label lbl = this.startLabel;
                int pos = -1;
                List<Label> lblList = this.trans.lblList;
                while (null != lbl) {
                    LocalVariableMetaInfo var = this.meta.localVariable(index, lbl);
                    if (null != var) {
                        return var.name();
                    }
                    if (-1 == pos && (pos = lblList.indexOf(lbl)) <= 0) {
                        return null;
                    }
                    lbl = lblList.get(--pos);
                }
                return null;
            }

            void handle(AbstractInsnNode node) {
                InstructionHandler handler = this.handlers.get(node.getType());
                if (null != handler) {
                    handler.handle(node);
                }
            }
        }

        private static abstract class InstructionHandler {
            Segment segment;
            HandlerMethodMetaInfo meta;

            InstructionHandler(Segment segment, HandlerMethodMetaInfo meta) {
                this.segment = segment;
                this.meta = meta;
            }

            protected abstract void handle(AbstractInsnNode var1);

            protected void refreshIteratorNext() {
                this.segment.itr.previous();
                this.segment.itr.next();
            }
        }
    }
}

