/*
 * Decompiled with CFR 0.152.
 */
package act.controller.bytecode;

import act.Act;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import act.view.FilteredRenderJSON;
import act.view.FilteredRenderXML;
import act.view.RenderAny;
import act.view.RenderCSV;
import act.view.RenderJsonMap;
import act.view.RenderTemplate;
import act.view.ZXingResult;
import java.util.HashSet;
import java.util.Set;
import org.osgl.Lang;
import org.osgl.mvc.result.Accepted;
import org.osgl.mvc.result.BadRequest;
import org.osgl.mvc.result.Conflict;
import org.osgl.mvc.result.Created;
import org.osgl.mvc.result.ErrorResult;
import org.osgl.mvc.result.Forbidden;
import org.osgl.mvc.result.MethodNotAllowed;
import org.osgl.mvc.result.NoResult;
import org.osgl.mvc.result.NotAcceptable;
import org.osgl.mvc.result.NotFound;
import org.osgl.mvc.result.NotImplemented;
import org.osgl.mvc.result.NotModified;
import org.osgl.mvc.result.Ok;
import org.osgl.mvc.result.Redirect;
import org.osgl.mvc.result.RenderBinary;
import org.osgl.mvc.result.RenderContent;
import org.osgl.mvc.result.RenderHtml;
import org.osgl.mvc.result.RenderJSON;
import org.osgl.mvc.result.RenderText;
import org.osgl.mvc.result.RenderXML;
import org.osgl.mvc.result.Result;
import org.osgl.mvc.result.ServerError;
import org.osgl.mvc.result.Unauthorized;

class ResultClassLookup {
    private static volatile ResultClassLookup _inst;
    private Set<String> _set = new HashSet<String>();

    private ResultClassLookup() {
        this.loadResultClasses();
    }

    private void loadResultClasses() {
        String RESULT = Result.class.getName();
        this._set.add(RESULT);
        ClassInfoRepository repo = Act.app().classLoader().classInfoRepository();
        ClassNode resultNode = repo.node(RESULT);
        if (null == resultNode) {
            this.add(Ok.class, NotFound.class, ErrorResult.class, NotAcceptable.class, Forbidden.class, NotImplemented.class, BadRequest.class, Conflict.class, MethodNotAllowed.class, Unauthorized.class, ServerError.class, NotModified.class, RenderBinary.class, Accepted.class, Created.class, NoResult.class, Redirect.class, RenderTemplate.class, RenderAny.class, ZXingResult.class, RenderJsonMap.class, RenderJSON.class, RenderContent.class, RenderXML.class, RenderCSV.class, RenderHtml.class, FilteredRenderJSON.class, FilteredRenderXML.class, RenderText.class);
        } else {
            resultNode.visitPublicSubTreeNodes(new Lang.Visitor<ClassNode>(){

                public void visit(ClassNode classNode) throws Lang.Break {
                    ResultClassLookup.this._set.add(classNode.name());
                }
            });
        }
    }

    private ResultClassLookup add(Class<? extends Result> ... resultClasses) {
        for (Class<? extends Result> resultClass : resultClasses) {
            this._set.add(resultClass.getName());
        }
        return this;
    }

    public static boolean isResult(String className) {
        return ResultClassLookup.get()._set.contains(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResultClassLookup get() {
        if (null != _inst) return _inst;
        Class<ResultClassLookup> clazz = ResultClassLookup.class;
        synchronized (ResultClassLookup.class) {
            if (null != _inst) return _inst;
            _inst = new ResultClassLookup();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _inst;
        }
    }
}

