/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import act.Destroyable;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.controller.meta.InterceptorType;
import act.util.DestroyableBase;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.S;

@ApplicationScoped
public class GroupInterceptorMetaInfo
extends DestroyableBase {
    private C.List<InterceptorMethodMetaInfo> beforeList = C.newList();
    private C.List<InterceptorMethodMetaInfo> afterList = C.newList();
    private C.List<InterceptorMethodMetaInfo> catchList = C.newList();
    private C.List<InterceptorMethodMetaInfo> finallyList = C.newList();

    public GroupInterceptorMetaInfo() {
    }

    public GroupInterceptorMetaInfo(GroupInterceptorMetaInfo copy) {
        this.mergeFrom(copy);
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.destroyAll(this.beforeList, ApplicationScoped.class);
        Destroyable.Util.destroyAll(this.afterList, ApplicationScoped.class);
        Destroyable.Util.destroyAll(this.catchList, ApplicationScoped.class);
        Destroyable.Util.destroyAll(this.finallyList, ApplicationScoped.class);
        this.beforeList.clear();
        this.afterList.clear();
        this.catchList.clear();
        this.finallyList.clear();
        super.releaseResources();
    }

    public void addBefore(InterceptorMethodMetaInfo before) {
        this.beforeList.add((Object)before);
    }

    public void addAfter(InterceptorMethodMetaInfo after) {
        this.afterList.add((Object)after);
    }

    public void addCatch(CatchMethodMetaInfo cat) {
        this.catchList.add((Object)cat);
    }

    public void addFinally(InterceptorMethodMetaInfo after) {
        this.finallyList.add((Object)after);
    }

    public void add(InterceptorMethodMetaInfo info, Class<? extends Annotation> interceptorType) {
        InterceptorType.of(interceptorType).addToGroup(info, this);
    }

    public void add(InterceptorMethodMetaInfo info, InterceptorType type) {
        type.addToGroup(info, this);
    }

    public C.List<InterceptorMethodMetaInfo> beforeList() {
        return C.list(this.beforeList);
    }

    public C.List<InterceptorMethodMetaInfo> afterList() {
        return C.list(this.afterList);
    }

    public C.List<CatchMethodMetaInfo> catchList() {
        return C.list(this.catchList);
    }

    public C.List<InterceptorMethodMetaInfo> finallyList() {
        return C.list(this.finallyList);
    }

    private C.List<InterceptorMethodMetaInfo> allList() {
        return this.beforeList().lazy().append(this.afterList()).append(this.catchList()).append(this.finallyList());
    }

    public InterceptorMethodMetaInfo find(String methodName, String className) {
        for (InterceptorMethodMetaInfo info : this.allList()) {
            String infoMethodName = info.name();
            String infoClassName = info.classInfo().className();
            if (!S.eq((String)methodName, (String)infoMethodName) || !S.eq((String)className, (String)infoClassName)) continue;
            return info;
        }
        return null;
    }

    public void mergeFrom(GroupInterceptorMetaInfo info, ControllerClassMetaInfo targetController) {
        GroupInterceptorMetaInfo.mergeList(this.beforeList, targetController.convertDerived(info.beforeList));
        GroupInterceptorMetaInfo.mergeList(this.afterList, targetController.convertDerived(info.afterList));
        GroupInterceptorMetaInfo.mergeList(this.catchList, targetController.convertDerived(info.catchList));
        GroupInterceptorMetaInfo.mergeList(this.finallyList, targetController.convertDerived(info.finallyList));
    }

    public void mergeFrom(GroupInterceptorMetaInfo info) {
        GroupInterceptorMetaInfo.mergeList(this.beforeList, info.beforeList);
        GroupInterceptorMetaInfo.mergeList(this.afterList, info.afterList);
        GroupInterceptorMetaInfo.mergeList(this.catchList, info.catchList);
        GroupInterceptorMetaInfo.mergeList(this.finallyList, info.finallyList);
    }

    public void mergeFrom(GroupInterceptorMetaInfo classInterceptors, String actionName) {
        classInterceptors.beforeList.each(_F.mergeInto(this.beforeList, actionName));
        classInterceptors.afterList.each(_F.mergeInto(this.afterList, actionName));
        classInterceptors.catchList.each(_F.mergeInto(this.catchList, actionName));
        classInterceptors.finallyList.each(_F.mergeInto(this.finallyList, actionName));
        this.beforeList = this.beforeList.sorted();
        this.afterList = this.afterList.sorted();
        this.catchList = this.catchList.sorted();
        this.finallyList = this.finallyList.sorted();
    }

    public String toString() {
        S.Buffer sb = S.buffer();
        this.appendList("BEFORE", (List<?>)this.beforeList, sb);
        this.appendList("AFTER", (List<?>)this.afterList, sb);
        this.appendList("CATCH", (List<?>)this.catchList, sb);
        this.appendList("FINALLY", (List<?>)this.finallyList, sb);
        return sb.toString();
    }

    private static <T> void mergeList(List<? super T> toList, List<? extends T> fromList) {
        for (T t : fromList) {
            if (toList.contains(t)) continue;
            toList.add(t);
        }
    }

    private void appendList(String label, List<?> list, S.Buffer sb) {
        if (list.isEmpty()) {
            return;
        }
        if (sb.length() > 0) {
            sb.append("\n");
        }
        sb.append(label).append("\n").append(S.join((String)"\n", list));
    }

    private static enum _F {


        static Lang.Visitor<InterceptorMethodMetaInfo> mergeInto(final C.List<InterceptorMethodMetaInfo> toList, final String actionName) {
            return new Lang.Visitor<InterceptorMethodMetaInfo>(){

                public void visit(InterceptorMethodMetaInfo info) throws Lang.Break {
                    info.mergeInto((C.List<InterceptorMethodMetaInfo>)toList, actionName);
                }
            };
        }
    }
}

