/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.GroupInterceptorMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.osgl.mvc.annotation.After;
import org.osgl.mvc.annotation.Before;
import org.osgl.mvc.annotation.Catch;
import org.osgl.mvc.annotation.Finally;
import org.osgl.util.C;
import org.osgl.util.E;

public enum InterceptorType {
    BEFORE{

        @Override
        void addToGroup(InterceptorMethodMetaInfo info, GroupInterceptorMetaInfo group) {
            group.addBefore(info);
        }
    }
    ,
    AFTER{

        @Override
        void addToGroup(InterceptorMethodMetaInfo info, GroupInterceptorMetaInfo group) {
            group.addAfter(info);
        }
    }
    ,
    CATCH{

        @Override
        void addToGroup(InterceptorMethodMetaInfo info, GroupInterceptorMetaInfo group) {
            group.addCatch((CatchMethodMetaInfo)info);
        }

        @Override
        public InterceptorMethodMetaInfo createMetaInfo(ControllerClassMetaInfo clsInfo) {
            return new CatchMethodMetaInfo(clsInfo);
        }
    }
    ,
    FINALLY{

        @Override
        void addToGroup(InterceptorMethodMetaInfo info, GroupInterceptorMetaInfo group) {
            group.addFinally(info);
        }
    };

    private static Map<Class<? extends Annotation>, InterceptorType> map;

    abstract void addToGroup(InterceptorMethodMetaInfo var1, GroupInterceptorMetaInfo var2);

    public InterceptorMethodMetaInfo createMetaInfo(ControllerClassMetaInfo clsInfo) {
        return new InterceptorMethodMetaInfo(clsInfo);
    }

    public static InterceptorType of(Class<? extends Annotation> clz) {
        InterceptorType type = map.get(clz);
        E.illegalArgumentIf((null == type ? 1 : 0) != 0, (String)"Not an interceptor annotation: %s", (Object[])new Object[]{clz});
        return type;
    }

    static {
        map = C.Map((Object[])new Object[]{Before.class, BEFORE, After.class, AFTER, Catch.class, CATCH, Finally.class, FINALLY});
    }
}

