/*
 * Decompiled with CFR 0.152.
 */
package act.crypto;

import act.crypto.AppCrypto;
import act.session.RotationSecretProvider;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.util.S;

@Singleton
public class RotateSecretCrypto
extends AppCrypto {
    private RotationSecretProvider secretProvider;
    private boolean rotationEnabled;

    @Inject
    public RotateSecretCrypto(RotationSecretProvider secretProvider) {
        super(secretProvider.rawSecret());
        this.rotationEnabled = secretProvider.isRotateEnabled();
        this.secretProvider = secretProvider;
    }

    @Override
    public String sign(String message) {
        return !this.rotationEnabled ? super.sign(message) : this.cur().sign(message);
    }

    public boolean verifySignature(String message, String signature) {
        if (!this.rotationEnabled) {
            return S.eq((String)signature, (String)super.sign(message));
        }
        return S.eq((String)signature, (String)this.cur().sign(message)) || S.eq((String)signature, (String)this.prev().sign(message)) || S.eq((String)signature, (String)this.next().sign(message));
    }

    @Override
    public char[] passwordHash(char[] password) {
        return super.passwordHash(password);
    }

    @Override
    public String passwordHash(String password) {
        return super.passwordHash(password);
    }

    @Override
    public boolean verifyPassword(String password, String hash) {
        return super.verifyPassword(password, hash);
    }

    @Override
    public boolean verifyPassword(char[] password, String hash) {
        return super.verifyPassword(password, hash);
    }

    @Override
    public boolean verifyPassword(char[] password, char[] hash) {
        return super.verifyPassword(password, hash);
    }

    @Override
    public String encrypt(String message) {
        return !this.rotationEnabled ? super.encrypt(message) : this.cur().encrypt(message);
    }

    @Override
    public String decrypt(String message) {
        if (!this.rotationEnabled) {
            return super.decrypt(message);
        }
        try {
            return this.cur().decrypt(message);
        }
        catch (Exception e) {
            try {
                return this.prev().decrypt(message);
            }
            catch (Exception e1) {
                return this.next().decrypt(message);
            }
        }
    }

    private AppCrypto cur() {
        return new AppCrypto(this.secretProvider.curSecret());
    }

    private AppCrypto prev() {
        return new AppCrypto(this.secretProvider.lastSecret());
    }

    private AppCrypto next() {
        return new AppCrypto(this.secretProvider.nextSecret());
    }
}

