/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public abstract class DateResolverBase<T extends Date>
extends StringValueResolver<T> {
    static Logger logger = L.get(DateResolverBase.class);
    protected DateFormat dateFormat;
    protected DateFormat dateFormat2;

    public DateResolverBase(AppConfig config) {
        String pattern = this.configuredPattern(config);
        if (null == pattern || pattern.contains("8601") || pattern.contains("iso")) {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            this.dateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        } else {
            this.dateFormat = new SimpleDateFormat(pattern);
        }
    }

    public DateResolverBase(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public final T resolve(String value) {
        if (S.blank((String)value)) {
            return null;
        }
        Date date = this.parse(value);
        if (null == date) {
            return null;
        }
        return this.cast(date);
    }

    protected String configuredPattern(AppConfig config) {
        return config.dateFormat();
    }

    protected abstract T cast(Date var1);

    private Date parse(String value) {
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            if (null == this.dateFormat2) {
                logger.error("error parsing date value from: %s", new Object[]{value});
                return null;
            }
            try {
                return this.dateFormat2.parse(value);
            }
            catch (ParseException e2) {
                logger.error("error parsing date value from: %s", new Object[]{value});
                return null;
            }
        }
    }
}

