/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.JodaDateTimeCodecBase;
import act.data.JodaReadableInstantCodecBase;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Singleton
public class JodaDateTimeCodec
extends JodaReadableInstantCodecBase<DateTime> {
    public JodaDateTimeCodec(DateTimeFormatter formatter) {
        super(formatter);
    }

    public JodaDateTimeCodec(String pattern) {
        super(pattern);
    }

    @Inject
    public JodaDateTimeCodec(AppConfig config) {
        this(config.dateTimeFormat());
    }

    @Override
    protected DateTimeFormatter isoFormatter() {
        return ISODateTimeFormat.dateTime();
    }

    @Override
    protected JodaDateTimeCodecBase<DateTime> create(String pattern) {
        return new JodaDateTimeCodec(pattern);
    }

    @Override
    protected DateTime parse(DateTimeFormatter formatter, String value) {
        return formatter.parseDateTime(value);
    }

    @Override
    protected DateTime now() {
        return DateTime.now();
    }
}

