/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.data.annotation.DateFormatPattern;
import act.data.annotation.Pattern;
import act.util.ActContext;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.osgl.$;
import org.osgl.util.AnnotationAware;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;
import org.osgl.util.ValueObject;

public abstract class JodaDateTimeCodecBase<T>
extends StringValueResolver<T>
implements ValueObject.Codec<T> {
    private DateTimeFormatter formatter;

    public JodaDateTimeCodecBase(DateTimeFormatter formatter) {
        this.formatter(formatter);
    }

    public JodaDateTimeCodecBase(String pattern) {
        this.formatter(this.formatter(pattern));
    }

    public final T parse(String s) {
        return this.resolve(s);
    }

    public final Class<T> targetClass() {
        return this.targetType();
    }

    public final T resolve(String value) {
        return S.blank((String)value) ? null : (T)this.parse(this.formatter(), value);
    }

    public final String toJSONString(T o) {
        String s = this.toString(o);
        return S.newSizedBuffer((int)(s.length() + 2)).append("\"").append(s).append("\"").toString();
    }

    public final StringValueResolver<T> amended(AnnotationAware beanSpec) {
        DateFormatPattern dfp = (DateFormatPattern)beanSpec.getAnnotation(DateFormatPattern.class);
        if (null != dfp) {
            return this.create(dfp.value());
        }
        Pattern pattern = (Pattern)beanSpec.getAnnotation(Pattern.class);
        return null == pattern ? this : this.create(pattern.value());
    }

    protected abstract T parse(DateTimeFormatter var1, String var2);

    protected abstract DateTimeFormatter isoFormatter();

    protected abstract T now();

    private void verify() {
        T now = this.now();
        String s = this.toString(now);
        if (!s.equals(this.toString(this.parse(s)))) {
            throw new IllegalArgumentException("Invalid pattern");
        }
    }

    protected abstract JodaDateTimeCodecBase<T> create(String var1);

    protected final DateTimeFormatter formatter() {
        String pattern = ActContext.Base.currentDateFormatPattern();
        return null == pattern ? this.formatter : this.formatter(this.sanitize(pattern));
    }

    protected String sanitize(String dateTimePattern) {
        return dateTimePattern;
    }

    protected DateTimeFormatter defaultFormatter() {
        return this.formatter;
    }

    private void formatter(DateTimeFormatter formatter) {
        this.formatter = (DateTimeFormatter)$.notNull((Object)formatter);
        this.verify();
    }

    private DateTimeFormatter formatter(String pattern) {
        if (null == pattern) {
            return this.defaultFormatter();
        }
        return JodaDateTimeCodecBase.isIsoStandard(pattern) ? this.isoFormatter() : DateTimeFormat.forPattern((String)pattern);
    }

    public static boolean isIsoStandard(String pattern) {
        return null == pattern || pattern.contains("iso") || pattern.contains("ISO") || pattern.contains("8601");
    }
}

