/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.JodaDateTimeCodecBase;
import act.data.JodaReadablePatialCodecBase;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Singleton
public class JodaLocalDateCodec
extends JodaReadablePatialCodecBase<LocalDate> {
    public JodaLocalDateCodec(DateTimeFormatter formatter) {
        super(formatter);
    }

    public JodaLocalDateCodec(String pattern) {
        super(pattern);
    }

    @Inject
    public JodaLocalDateCodec(AppConfig config) {
        this(config.dateFormat());
    }

    @Override
    protected JodaDateTimeCodecBase<LocalDate> create(String pattern) {
        return new JodaLocalDateCodec(pattern);
    }

    @Override
    protected LocalDate parse(DateTimeFormatter formatter, String value) {
        return formatter.parseLocalDate(value);
    }

    @Override
    protected DateTimeFormatter isoFormatter() {
        return ISODateTimeFormat.localDateParser();
    }

    @Override
    protected LocalDate now() {
        return LocalDate.now();
    }

    @Override
    protected String sanitize(String dateTimePattern) {
        if (null == dateTimePattern) {
            return null;
        }
        if (dateTimePattern.contains("h") || dateTimePattern.contains("H") || dateTimePattern.contains("m") || dateTimePattern.contains("s") || dateTimePattern.contains("S")) {
            return null;
        }
        return dateTimePattern;
    }
}

