/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.JodaDateTimeCodecBase;
import act.data.JodaReadablePatialCodecBase;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Singleton
public class JodaLocalTimeCodec
extends JodaReadablePatialCodecBase<LocalTime> {
    private boolean isIso;

    public JodaLocalTimeCodec(DateTimeFormatter formatter, boolean isIso) {
        super(formatter);
        this.isIso = isIso;
    }

    public JodaLocalTimeCodec(String pattern) {
        super(pattern);
        this.isIso = JodaLocalTimeCodec.isIsoStandard(pattern);
    }

    @Inject
    public JodaLocalTimeCodec(AppConfig config) {
        this(config.timeFormat());
    }

    @Override
    protected LocalTime parse(DateTimeFormatter formatter, String value) {
        String amended = this.isIso && !value.endsWith("Z") ? value + "Z" : value;
        return formatter.parseLocalTime(amended);
    }

    @Override
    protected DateTimeFormatter isoFormatter() {
        return ISODateTimeFormat.timeNoMillis();
    }

    @Override
    protected LocalTime now() {
        return LocalTime.now();
    }

    @Override
    protected JodaDateTimeCodecBase<LocalTime> create(String pattern) {
        return new JodaLocalTimeCodec(pattern);
    }

    @Override
    protected String sanitize(String dateTimePattern) {
        if (null == dateTimePattern) {
            return null;
        }
        if (dateTimePattern.contains("M") || dateTimePattern.contains("y") || dateTimePattern.contains("d") || dateTimePattern.contains("Y") || dateTimePattern.contains("c") || dateTimePattern.contains("e") || dateTimePattern.contains("x") || dateTimePattern.contains("C") || dateTimePattern.contains("D") || dateTimePattern.contains("F") || dateTimePattern.contains("w") || dateTimePattern.contains("W") || dateTimePattern.contains("k") || dateTimePattern.contains("K")) {
            return null;
        }
        return dateTimePattern;
    }
}

