/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.app.App;
import act.data.DataPropertyRepository;
import act.data.util.StringOrPattern;
import act.util.ActContext;
import act.util.PropertySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.osgl.$;
import org.osgl.util.C;

class OutputFieldsCache {
    private Map<K, List<String>> cache = new HashMap<K, List<String>>();

    OutputFieldsCache() {
    }

    public List<String> getOutputFields(PropertySpec.MetaInfo spec, Class<?> componentClass, ActContext context) {
        K k = new K(spec.excludedFields(context), spec.outputFields(context), componentClass);
        List<String> outputs = this.cache.get(k);
        if (null == outputs) {
            outputs = this.calculateOutputs(k);
            this.cache.put(k, outputs);
        }
        return outputs;
    }

    List<String> calculateOutputs(K k) {
        Class<?> type = k.componentType;
        if ($.isSimpleType(type) && k.excluded.isEmpty() && k.outputs.isEmpty()) {
            return C.list();
        }
        ArrayList<StringOrPattern> outputs = new ArrayList<StringOrPattern>();
        boolean hasPattern = this.hasPattern(k.outputs, outputs);
        Set<String> excluded = k.excluded;
        if (hasPattern || outputs.isEmpty()) {
            DataPropertyRepository repo = App.instance().service(DataPropertyRepository.class);
            List<String> allFields = repo.propertyListOf(k.componentType);
            if (!excluded.isEmpty()) {
                ArrayList<StringOrPattern> lsp = new ArrayList<StringOrPattern>();
                boolean excludeHasPattern = this.hasPattern(excluded, lsp);
                if (!excludeHasPattern) {
                    return C.list(allFields).without(excluded);
                }
                C.List finalOutputs = C.newList(allFields);
                block0: for (String s : allFields) {
                    for (StringOrPattern sp : lsp) {
                        if (!sp.matches(s)) continue;
                        finalOutputs.remove(s);
                        continue block0;
                    }
                }
                return finalOutputs;
            }
            if (outputs.isEmpty()) {
                return allFields;
            }
            ArrayList<String> finalOutputs = new ArrayList<String>();
            for (StringOrPattern sp : outputs) {
                if (sp.isPattern()) {
                    Pattern p = sp.p();
                    for (String s : allFields) {
                        if (!p.matcher(s).matches()) continue;
                        finalOutputs.add(s);
                    }
                    continue;
                }
                finalOutputs.add(sp.s());
            }
            return finalOutputs;
        }
        return k.outputs;
    }

    private boolean hasPattern(Collection<String> ls, List<StringOrPattern> lsp) {
        boolean b = false;
        for (String s : ls) {
            StringOrPattern sp = new StringOrPattern(s);
            b = b || sp.isPattern();
            lsp.add(sp);
        }
        return b;
    }

    private class K {
        Set<String> excluded;
        List<String> outputs;
        Class<?> componentType;

        K(Set<String> ss, List<String> ls, Class<?> componentType) {
            this.excluded = ss;
            this.outputs = ls;
            this.componentType = componentType;
        }

        public int hashCode() {
            return $.hc(this.excluded, this.outputs, this.componentType);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof K) {
                K that = (K)obj;
                return $.eq(that.excluded, this.excluded) && $.eq(that.outputs, this.outputs) && $.eq(that.componentType, this.componentType);
            }
            return false;
        }
    }
}

