/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.app.App;
import act.asm.AnnotationVisitor;
import act.asm.ClassVisitor;
import act.asm.FieldVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.util.AppByteCodeEnhancer;
import act.util.SimpleBean;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgl.Lang;
import org.osgl.util.S;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface Sensitive {
    public static final String ASM_DESC = Type.getType(Sensitive.class).getDescriptor();

    public static class Enhancer
    extends AppByteCodeEnhancer<Enhancer> {
        private static final String DESC_SENSITIVE = ASM_DESC;
        private static final String DESC_STRING = Type.getType(String.class).getDescriptor();
        private static final String GETTER_DESC = S.concat((String)"()", (String)DESC_STRING);
        private static final String SETTER_DESC = S.concat((String)"(", (String)DESC_STRING, (String)")V");
        private Set<String> sensitiveFieldsForGetter = new HashSet<String>();
        private Set<String> sensitiveFieldsForSetter = new HashSet<String>();
        private SimpleBean.MetaInfoManager metaInfoManager;
        private SimpleBean.MetaInfo metaInfo;
        private String classInternalName;
        private String className;
        private static final AtomicBoolean generatingMethods = new AtomicBoolean(false);

        public Enhancer() {
            super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate());
        }

        public Enhancer(ClassVisitor cv) {
            super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate(), cv);
        }

        @Override
        public AppByteCodeEnhancer app(App app) {
            this.metaInfoManager = app.classLoader().simpleBeanInfoManager();
            return super.app(app);
        }

        @Override
        protected Class<Enhancer> subClass() {
            return Enhancer.class;
        }

        @Override
        protected void reset() {
            this.sensitiveFieldsForSetter.clear();
            this.sensitiveFieldsForGetter.clear();
            this.className = null;
            this.classInternalName = null;
            this.metaInfo = null;
            super.reset();
        }

        @Override
        public int priority() {
            return 10;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classInternalName = name;
            this.className = Type.getObjectType((String)name).getClassName();
            this.metaInfo = this.metaInfoManager.get(this.className);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, final String name, String fieldDesc, String signature, Object value) {
            FieldVisitor fv = super.visitField(access, name, fieldDesc, signature, value);
            boolean isStatic = (access & 8) != 0;
            return isStatic || S.neq((String)DESC_STRING, (String)fieldDesc) ? fv : new FieldVisitor(327680, fv){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (DESC_SENSITIVE.equals(desc)) {
                        Enhancer.this.sensitiveFieldsForGetter.add(name);
                        Enhancer.this.sensitiveFieldsForSetter.add(name);
                        if (null != Enhancer.this.metaInfo) {
                            Enhancer.this.metaInfo.addSensitiveField(name);
                        }
                    }
                    return super.visitAnnotation(desc, visible);
                }
            };
        }

        public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
            String fieldName = this.fieldNameFromGetterOrSetter(methodName);
            final String mappedFieldName = null != this.metaInfo ? this.metaInfo.aliasOf(fieldName) : fieldName;
            final boolean isSetter = null != fieldName && methodName.startsWith("s");
            Set<String> backlog = isSetter ? this.sensitiveFieldsForSetter : this.sensitiveFieldsForGetter;
            return null == fieldName || !backlog.contains(mappedFieldName) ? mv : new MethodVisitor(327680, mv){

                public void visitCode() {
                    boolean generating = generatingMethods.get();
                    if (!generating) {
                        if (isSetter) {
                            logger.warn(methodName + "(" + Type.getType((String)methodDesc).getArgumentTypes()[0].getClassName() + ") rewritten for @Sensitive field: " + mappedFieldName);
                        } else {
                            logger.warn(methodName + "() rewritten for @Sensitive field: " + mappedFieldName);
                        }
                    }
                    if (isSetter) {
                        Enhancer.this.visitSetterCode(mappedFieldName, this);
                        if (!generating) {
                            Enhancer.this.sensitiveFieldsForSetter.remove(mappedFieldName);
                        }
                    } else {
                        Enhancer.this.visitGetterCode(mappedFieldName, this);
                        if (!generating) {
                            Enhancer.this.sensitiveFieldsForGetter.remove(mappedFieldName);
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitEnd() {
            MethodVisitor mv;
            super.visitEnd();
            for (String field : this.sensitiveFieldsForGetter) {
                generatingMethods.set(true);
                try {
                    mv = this.visitMethod(1, Enhancer.getterName(field), GETTER_DESC, null, null);
                    mv.visitCode();
                }
                finally {
                    generatingMethods.set(false);
                }
            }
            for (String field : this.sensitiveFieldsForSetter) {
                generatingMethods.set(true);
                try {
                    mv = this.visitMethod(1, Enhancer.setterName(field), SETTER_DESC, null, null);
                    mv.visitCode();
                }
                finally {
                    generatingMethods.set(false);
                }
            }
        }

        private String fieldNameFromGetterOrSetter(String methodName) {
            int len = methodName.length();
            if (len > 3 && (methodName.startsWith("get") || methodName.startsWith("set"))) {
                return S.lowerFirst((String)methodName.substring(3));
            }
            return null;
        }

        private void visitSetterCode(String field, MethodVisitor mv) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "act/Act", "crypto", "()Lact/crypto/AppCrypto;", false);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "act/crypto/AppCrypto", "encrypt", "(Ljava/lang/String;)Ljava/lang/String;", false);
            mv.visitFieldInsn(181, this.classInternalName, field, DESC_STRING);
            mv.visitInsn(177);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
        }

        private void visitGetterCode(String field, MethodVisitor mv) {
            mv.visitMethodInsn(184, "act/Act", "crypto", "()Lact/crypto/AppCrypto;", false);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classInternalName, field, "Ljava/lang/String;");
            mv.visitMethodInsn(182, "act/crypto/AppCrypto", "decrypt", "(Ljava/lang/String;)Ljava/lang/String;", false);
            mv.visitInsn(176);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }

        private static String getterName(String fieldName) {
            return S.concat((String)"get", (String)S.capFirst((String)fieldName));
        }

        private static String setterName(String fieldName) {
            return "set" + S.capFirst((String)fieldName);
        }
    }
}

