/*
 * Decompiled with CFR 0.152.
 */
package act.db;

import act.db.DbPlugin;
import act.db.TimestampGenerator;
import act.util.DestroyableBase;
import java.util.HashMap;
import java.util.Map;
import org.osgl.$;

public class DbManager
extends DestroyableBase {
    private Map<String, DbPlugin> plugins = new HashMap<String, DbPlugin>();
    private Map<Class, TimestampGenerator> timestampGeneratorMap = new HashMap<Class, TimestampGenerator>();

    synchronized void register(DbPlugin plugin) {
        this.plugins.put(plugin.getClass().getCanonicalName(), plugin);
    }

    synchronized void register(TimestampGenerator timestampGenerator) {
        this.timestampGeneratorMap.put(timestampGenerator.timestampType(), timestampGenerator);
    }

    public synchronized DbPlugin plugin(String type) {
        return this.plugins.get(type);
    }

    public synchronized boolean hasPlugin() {
        return !this.plugins.isEmpty();
    }

    public synchronized <TIMESTAMP_TYPE> TimestampGenerator<TIMESTAMP_TYPE> timestampGenerator(Class<? extends TIMESTAMP_TYPE> c) {
        return (TimestampGenerator)$.cast((Object)this.timestampGeneratorMap.get(c));
    }

    public synchronized DbPlugin theSolePlugin() {
        if (this.plugins.size() == 1) {
            return this.plugins.values().iterator().next();
        }
        return null;
    }
}

