/*
 * Decompiled with CFR 0.152.
 */
package act.event.bytecode;

import act.app.AppByteCodeScannerBase;
import act.app.event.SysEventId;
import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.event.EventBus;
import act.event.On;
import act.event.OnClass;
import act.event.OnEvent;
import act.event.SimpleEventListener;
import act.event.bytecode.ReflectedSimpleEventListener;
import act.event.meta.SimpleEventListenerMetaInfo;
import act.job.JobManager;
import act.util.AsmTypes;
import act.util.Async;
import act.util.ByteCodeVisitor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.S;

public class SimpleEventListenerByteCodeScanner
extends AppByteCodeScannerBase {
    private List<SimpleEventListenerMetaInfo> metaInfoList = new ArrayList<SimpleEventListenerMetaInfo>();

    @Override
    protected void reset(String className) {
        this.metaInfoList.clear();
    }

    @Override
    protected boolean shouldScan(String className) {
        return true;
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
        if (!this.metaInfoList.isEmpty()) {
            final EventBus eventBus = this.app().eventBus();
            JobManager jobManager = this.app().jobManager();
            for (final SimpleEventListenerMetaInfo metaInfo : this.metaInfoList) {
                SysEventId hookOn = metaInfo.beforeAppStart() ? SysEventId.DEPENDENCY_INJECTOR_PROVISIONED : SysEventId.PRE_START;
                jobManager.on(hookOn, new Runnable(){

                    @Override
                    public void run() {
                        for (Object event : metaInfo.events()) {
                            boolean isStatic = metaInfo.isStatic();
                            eventBus.bind(event, new ReflectedSimpleEventListener(metaInfo.className(), metaInfo.methodName(), metaInfo.paramTypes(), isStatic));
                        }
                    }
                });
            }
        }
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        private String className;

        private _ByteCodeVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = Type.getObjectType((String)name).getClassName();
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            Type returnType = Type.getReturnType((String)desc);
            final boolean isVoid = "V".equals(returnType.toString());
            final boolean isPublicNotAbstract = AsmTypes.isPublicNotAbstract(access);
            Type[] arguments = Type.getArgumentTypes((String)desc);
            final ArrayList<String> paramTypes = new ArrayList<String>();
            if (null != arguments) {
                for (Type type : arguments) {
                    paramTypes.add(type.getClassName());
                }
            }
            final String methodName = name;
            final boolean isStatic = AsmTypes.isStatic(access);
            return new MethodVisitor(327680, mv){
                private List<Object> events;
                private List<Lang.Func0> delayedEvents;
                private boolean isOnEvent;
                private boolean beforeAppStart;
                private boolean isAsync;
                private String asyncMethodName;
                {
                    super(x0, x1);
                    this.events = new ArrayList<Object>();
                    this.delayedEvents = new ArrayList<Lang.Func0>();
                    this.isOnEvent = false;
                    this.beforeAppStart = false;
                    this.asyncMethodName = null;
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationVisitor av = super.visitAnnotation(desc, visible);
                    String className = Type.getType((String)desc).getClassName();
                    final boolean isOn = On.class.getName().equals(className);
                    boolean isOnC = OnClass.class.getName().equals(className);
                    boolean isOnE = OnEvent.class.getName().equals(className);
                    if (isOnE) {
                        this.isOnEvent = true;
                    }
                    boolean isCustomMarker = false;
                    if (!(isOn || isOnC || isOnE)) {
                        Annotation[] annotations;
                        Class clz = $.classForName((String)className);
                        for (Annotation annotation : annotations = clz.getAnnotations()) {
                            if (!SimpleEventListener.Marker.class.getCanonicalName().equals(annotation.annotationType().getCanonicalName())) continue;
                            isCustomMarker = true;
                            break;
                        }
                    }
                    if (isOnE || isOn || isOnC || isCustomMarker) {
                        return new AnnotationVisitor(327680, av){

                            public AnnotationVisitor visitArray(String name) {
                                AnnotationVisitor av0 = super.visitArray(name);
                                if ("value".equals(name)) {
                                    return new AnnotationVisitor(327680, av0){

                                        public void visit(String name, Object value) {
                                            if (isOn) {
                                                events.add(S.string((Object)value).intern());
                                            } else {
                                                Type type = (Type)value;
                                                Class c = $.classForName((String)type.getClassName(), (ClassLoader)SimpleEventListenerByteCodeScanner.this.app().classLoader());
                                                events.add(c);
                                            }
                                            super.visit(name, value);
                                        }

                                        public void visitEnum(String name, String desc, final String value) {
                                            final String enumClassName = Type.getType((String)desc).getClassName();
                                            delayedEvents.add(new Lang.Func0(){

                                                public Object apply() throws NotAppliedException, Lang.Break {
                                                    Class enumClass = $.classForName((String)enumClassName, (ClassLoader)SimpleEventListenerByteCodeScanner.this.app().classLoader());
                                                    return Enum.valueOf(enumClass, value);
                                                }
                                            });
                                            super.visitEnum(name, desc, value);
                                        }
                                    };
                                }
                                return av0;
                            }

                            public void visit(String name, Object value) {
                                if ("async".equals(name)) {
                                    isAsync = Boolean.parseBoolean(S.string((Object)value));
                                } else if ("beforeAppStart".equals(name)) {
                                    beforeAppStart = Boolean.parseBoolean(S.string((Object)value));
                                }
                                super.visit(name, value);
                            }

                            public void visitEnum(String name, String desc, final String value) {
                                if ("value".equals(name)) {
                                    final String enumClassName = Type.getType((String)desc).getClassName();
                                    delayedEvents.add(new Lang.Func0(){

                                        public Object apply() throws NotAppliedException, Lang.Break {
                                            Class enumClass = $.classForName((String)enumClassName, (ClassLoader)SimpleEventListenerByteCodeScanner.this.app().classLoader());
                                            return Enum.valueOf(enumClass, value);
                                        }
                                    });
                                }
                                super.visitEnum(name, desc, value);
                            }
                        };
                    }
                    if (Async.class.getName().equals(className)) {
                        if (!isVoid) {
                            logger.warn("Error found in method %s.%s: @Async annotation cannot be used with method that has return type", new Object[]{className, methodName});
                        } else if (!isPublicNotAbstract) {
                            logger.warn("Error found in method %s.%s: @Async annotation cannot be used with method that are not public or abstract method", new Object[]{className, methodName});
                        } else {
                            this.asyncMethodName = Async.MethodNameTransformer.transform(methodName);
                        }
                        return av;
                    }
                    return av;
                }

                public void visitEnd() {
                    if (this.isOnEvent) {
                        if (paramTypes.isEmpty()) {
                            logger.warn("@OnEvent annotation shall be put on a method with exactly one event object (optionally with other injectable arguments");
                        } else {
                            String type = (String)paramTypes.get(0);
                            this.events.add($.classForName((String)type, (ClassLoader)SimpleEventListenerByteCodeScanner.this.app().classLoader()));
                        }
                    }
                    if (!this.events.isEmpty() || !this.delayedEvents.isEmpty()) {
                        SimpleEventListenerMetaInfo metaInfo = new SimpleEventListenerMetaInfo(this.events, this.delayedEvents, _ByteCodeVisitor.this.className, methodName, this.asyncMethodName, paramTypes, this.isAsync, isStatic, this.beforeAppStart, SimpleEventListenerByteCodeScanner.this.app());
                        SimpleEventListenerByteCodeScanner.this.metaInfoList.add(metaInfo);
                    }
                    super.visitEnd();
                }
            };
        }
    }
}

