/*
 * Decompiled with CFR 0.152.
 */
package act.handler;

import act.app.ActionContext;
import act.handler.OptionsRequestHandler;
import act.handler.RequestHandler;
import act.handler.builtin.AlwaysNotFound;
import act.handler.builtin.UnknownHttpMethodHandler;
import act.route.Router;
import act.security.CORS;
import act.util.DestroyableBase;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.http.H;
import org.osgl.util.S;

public class OptionsInfoBase
extends DestroyableBase {
    private Router router;
    private ConcurrentMap<String, RequestHandler> handlers = new ConcurrentHashMap<String, RequestHandler>();

    public OptionsInfoBase(Router router) {
        this.router = router;
    }

    public RequestHandler optionHandler(CharSequence path, ActionContext context) {
        String s = S.string((Object)path);
        RequestHandler handler = (RequestHandler)this.handlers.get(s);
        if (null == handler) {
            RequestHandler newHandler = this.createHandler(path, context);
            handler = this.handlers.putIfAbsent(s, newHandler);
            if (null == handler) {
                handler = newHandler;
            } else {
                newHandler.destroy();
            }
        }
        return handler;
    }

    private RequestHandler createHandler(CharSequence path, ActionContext context) {
        if (!this.router.app().config().corsEnabled()) {
            return UnknownHttpMethodHandler.INSTANCE;
        }
        ArrayList<H.Method> allowMethods = new ArrayList<H.Method>();
        ArrayList<CORS.Spec> corsSpecs = new ArrayList<CORS.Spec>();
        OptionsInfoBase optionsInfoBase = this;
        for (H.Method method : optionsInfoBase.router.supportedHttpMethods()) {
            RequestHandler handler = this.router.getInvoker(method, path, context);
            if (handler instanceof AlwaysNotFound) continue;
            allowMethods.add(method);
            CORS.Spec corsSpec = handler.corsSpec();
            if (corsSpec == CORS.Spec.DUMB) continue;
            corsSpecs.add(corsSpec);
        }
        if (allowMethods.isEmpty()) {
            return AlwaysNotFound.INSTANCE;
        }
        CORS.Spec corsSpec = CORS.spec(allowMethods);
        for (CORS.Spec spec : corsSpecs) {
            corsSpec = corsSpec.chain(spec);
        }
        return new OptionsRequestHandler(corsSpec);
    }
}

