/*
 * Decompiled with CFR 0.152.
 */
package act.handler;

import act.app.ActionContext;
import act.handler.ExpressHandler;
import act.handler.RequestHandler;
import act.handler.SimpleRequestHandler;
import act.security.CORS;
import act.security.CSRF;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;

public abstract class RequestHandlerBase
extends Lang.F1<ActionContext, Void>
implements RequestHandler {
    protected Logger logger = LogManager.get(this.getClass());
    private boolean destroyed;
    private boolean sessionFree = false;
    private boolean requireContextResolving = true;
    private boolean express = this instanceof ExpressHandler;

    public final Void apply(ActionContext context) throws NotAppliedException, Lang.Break {
        this.handle(context);
        return null;
    }

    public RequestHandlerBase setExpress() {
        this.express = true;
        return this;
    }

    @Override
    public boolean express(ActionContext context) {
        return this.express;
    }

    @Override
    public final Class<? extends Annotation> scope() {
        return ApplicationScoped.class;
    }

    @Override
    public boolean supportPartialPath() {
        return false;
    }

    @Override
    public boolean requireResolveContext() {
        return this.requireContextResolving;
    }

    public RequestHandlerBase noContextResoving() {
        this.requireContextResolving = false;
        return this;
    }

    public RequestHandler realHandler() {
        return this;
    }

    public RequestHandlerBase setSessionFree() {
        this.sessionFree = true;
        return this;
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean sessionFree() {
        return this.sessionFree;
    }

    @Override
    public CORS.Spec corsSpec() {
        return CORS.Spec.DUMB;
    }

    @Override
    public CSRF.Spec csrfSpec() {
        return CSRF.Spec.DUMB;
    }

    @Override
    public String contentSecurityPolicy() {
        return null;
    }

    @Override
    public boolean disableContentSecurityPolicy() {
        return false;
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.releaseResources();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void releaseResources() {
    }

    public static RequestHandlerBase wrap(final SimpleRequestHandler handler) {
        return new RequestHandlerBase(){

            @Override
            public void handle(ActionContext context) {
                handler.handle(context);
            }

            @Override
            public void prepareAuthentication(ActionContext context) {
            }

            @Override
            public String toString() {
                return handler.toString();
            }
        }.setSessionFree().noContextResoving();
    }
}

