/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin.controller;

import act.app.ActionContext;
import act.handler.builtin.controller.ExceptionInterceptorInvoker;
import act.handler.builtin.controller.Handler;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.plugin.Plugin;
import act.security.CORS;
import java.util.Comparator;
import java.util.List;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.E;

public abstract class ExceptionInterceptor
extends Handler<ExceptionInterceptor>
implements Plugin,
ExceptionInterceptorInvoker,
Comparable<ExceptionInterceptor> {
    private List<Class<? extends Exception>> exClasses;
    public static Comparator<Class<? extends Exception>> EXCEPTION_WEIGHT_COMPARATOR = new Comparator<Class<? extends Exception>>(){

        @Override
        public int compare(Class<? extends Exception> o1, Class<? extends Exception> o2) {
            return ExceptionInterceptor.weight(o1) - ExceptionInterceptor.weight(o2);
        }
    };

    public ExceptionInterceptor() {
        this(0);
    }

    public ExceptionInterceptor(int priority) {
        this(priority, new Class[0]);
    }

    public ExceptionInterceptor(Class<? extends Exception> ... exClasses) {
        this(0, exClasses);
    }

    public ExceptionInterceptor(int priority, Class<? extends Exception> ... exClasses) {
        super(priority);
        this.exClasses = C.listOf((Object[])exClasses).sorted(EXCEPTION_WEIGHT_COMPARATOR);
    }

    public ExceptionInterceptor(int priority, List<Class<? extends Exception>> exClasses) {
        super(priority);
        E.illegalArgumentIf((boolean)exClasses.isEmpty());
        this.exClasses = C.list(exClasses).sorted(EXCEPTION_WEIGHT_COMPARATOR);
    }

    @Override
    public Result handle(Exception e, ActionContext actionContext) throws Exception {
        if (this.exClasses.isEmpty()) {
            return this.internalHandle(e, actionContext);
        }
        for (Class<? extends Exception> c : this.exClasses) {
            if (!c.isInstance(e)) continue;
            return this.internalHandle(e, actionContext);
        }
        return null;
    }

    @Override
    public int compareTo(ExceptionInterceptor o) {
        if (o == this) {
            return 0;
        }
        int thisPriority = this.priority();
        int thatPririty = o.priority();
        if (thisPriority > 0 && thatPririty < 0) {
            return 1;
        }
        if (thisPriority < 0 && thatPririty > 0) {
            return -1;
        }
        if (thisPriority < 0 && thatPririty < 0) {
            this.warn("Found more than one high priority Exception handlers", new Object[0]);
        }
        boolean iAmEmpty = this.exClasses.isEmpty();
        boolean uAreEmpty = o.exClasses.isEmpty();
        if (iAmEmpty) {
            return uAreEmpty ? 0 : 1;
        }
        if (uAreEmpty) {
            return -1;
        }
        int n = EXCEPTION_WEIGHT_COMPARATOR.compare(o.exClasses.get(0), this.exClasses.get(0));
        return 0 == n ? super.compareTo(o) : n;
    }

    @Override
    public CORS.Spec corsSpec() {
        return CORS.Spec.DUMB;
    }

    protected abstract Result internalHandle(Exception var1, ActionContext var2) throws Exception;

    @Override
    public void register() {
        RequestHandlerProxy.registerGlobalInterceptor(this);
    }

    public static int weight(Class c) {
        int i = 0;
        while (c != Object.class) {
            ++i;
            c = c.getSuperclass();
        }
        return i;
    }
}

