/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin.controller;

import act.Act;
import act.ActResponse;
import act.Destroyable;
import act.app.ActionContext;
import act.app.App;
import act.app.AppInterceptorManager;
import act.app.event.SysEventId;
import act.controller.CacheSupportMetaInfo;
import act.controller.ResponseCache;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.GroupInterceptorMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.controller.meta.InterceptorType;
import act.handler.RequestHandlerBase;
import act.handler.builtin.controller.ActionHandler;
import act.handler.builtin.controller.AfterInterceptor;
import act.handler.builtin.controller.BeforeInterceptor;
import act.handler.builtin.controller.ControllerAction;
import act.handler.builtin.controller.ExceptionInterceptor;
import act.handler.builtin.controller.FinallyInterceptor;
import act.handler.builtin.controller.Handler;
import act.security.CORS;
import act.security.CSRF;
import act.util.AnnotatedClassFinder;
import act.util.Global;
import act.util.MissingAuthenticationHandler;
import act.view.ActErrorResult;
import act.view.RenderAny;
import act.xio.WebSocketConnectionHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.cache.CacheService;
import org.osgl.exception.UnexpectedException;
import org.osgl.http.H;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.ErrorResult;
import org.osgl.mvc.result.Result;
import org.osgl.util.E;
import org.osgl.util.S;

@ApplicationScoped
public final class RequestHandlerProxy
extends RequestHandlerBase {
    private static Logger logger = L.get(RequestHandlerProxy.class);
    private static final List<BeforeInterceptor> globalBeforeInterceptors = new ArrayList<BeforeInterceptor>();
    private static final List<AfterInterceptor> globalAfterInterceptors = new ArrayList<AfterInterceptor>();
    private static final List<FinallyInterceptor> globalFinallyInterceptors = new ArrayList<FinallyInterceptor>();
    private static final List<ExceptionInterceptor> globalExceptionInterceptors = new ArrayList<ExceptionInterceptor>();
    private static final Set<GroupInterceptorMetaInfo> globalFreeStyleInterceptors = new HashSet<GroupInterceptorMetaInfo>();
    private static GroupInterceptorMetaInfo globalFreeStyleInterceptor = new GroupInterceptorMetaInfo();
    public static final GroupInterceptorWithResult GLOBAL_BEFORE_INTERCEPTOR = new GroupInterceptorWithResult(globalBeforeInterceptors);
    public static final GroupAfterInterceptor GLOBAL_AFTER_INTERCEPTOR = new GroupAfterInterceptor(globalAfterInterceptors);
    public static final GroupFinallyInterceptor GLOBAL_FINALLY_INTERCEPTOR = new GroupFinallyInterceptor(globalFinallyInterceptors);
    public static final GroupExceptionInterceptor GLOBAL_EXCEPTION_INTERCEPTOR = new GroupExceptionInterceptor(globalExceptionInterceptors);
    private App app;
    private AppInterceptorManager appInterceptor;
    private CacheService cache;
    private String controllerClassName;
    private String actionMethodName;
    private String actionPath;
    private Method actionMethod;
    private volatile ControllerAction actionHandler = null;
    private List<BeforeInterceptor> beforeInterceptors = new ArrayList<BeforeInterceptor>();
    private List<AfterInterceptor> afterInterceptors = new ArrayList<AfterInterceptor>();
    private List<ExceptionInterceptor> exceptionInterceptors = new ArrayList<ExceptionInterceptor>();
    private List<FinallyInterceptor> finallyInterceptors = new ArrayList<FinallyInterceptor>();
    private boolean sessionFree;
    private boolean express;
    private boolean supportCache;
    private CacheSupportMetaInfo cacheSupport;
    private MissingAuthenticationHandler missingAuthenticationHandler;
    private MissingAuthenticationHandler csrfFailureHandler;
    private WebSocketConnectionHandler webSocketConnectionHandler;
    final GroupInterceptorWithResult BEFORE_INTERCEPTOR = new GroupInterceptorWithResult(this.beforeInterceptors);
    final GroupAfterInterceptor AFTER_INTERCEPTOR = new GroupAfterInterceptor(this.afterInterceptors);
    final GroupFinallyInterceptor FINALLY_INTERCEPTOR = new GroupFinallyInterceptor(this.finallyInterceptors);
    final GroupExceptionInterceptor EXCEPTION_INTERCEPTOR = new GroupExceptionInterceptor(this.exceptionInterceptors);

    @Inject
    public RequestHandlerProxy(String actionMethodName, final App app) {
        int pos = actionMethodName.lastIndexOf(46);
        String ERR = "Invalid controller action: %s";
        E.illegalArgumentIf((pos < 0 ? 1 : 0) != 0, (String)"Invalid controller action: %s", (Object[])new Object[]{actionMethodName});
        this.controllerClassName = actionMethodName.substring(0, pos);
        E.illegalArgumentIf((boolean)S.isEmpty((String)this.controllerClassName), (String)"Invalid controller action: %s", (Object[])new Object[]{actionMethodName});
        this.actionMethodName = actionMethodName.substring(pos + 1);
        E.illegalArgumentIf((boolean)S.isEmpty((String)this.actionMethodName), (String)"Invalid controller action: %s", (Object[])new Object[]{actionMethodName});
        this.actionPath = actionMethodName;
        if (app.classLoader() != null) {
            this.cache = app.config().cacheService("action_proxy");
        } else {
            app.jobManager().on(SysEventId.CLASS_LOADER_INITIALIZED, new Runnable(){

                @Override
                public void run() {
                    RequestHandlerProxy.this.cache = app.config().cacheService("action_proxy");
                }
            });
        }
        this.app = app;
        this.appInterceptor = app.interceptorManager();
    }

    @Override
    protected void releaseResources() {
        RequestHandlerProxy._releaseResourceCollections(this.afterInterceptors);
        RequestHandlerProxy._releaseResourceCollections(this.beforeInterceptors);
        RequestHandlerProxy._releaseResourceCollections(this.exceptionInterceptors);
        RequestHandlerProxy._releaseResourceCollections(this.finallyInterceptors);
        if (null != this.actionHandler) {
            this.actionHandler.destroy();
            this.actionHandler = null;
        }
    }

    public static void releaseGlobalResources() {
        RequestHandlerProxy._releaseResourceCollections(globalAfterInterceptors);
        RequestHandlerProxy._releaseResourceCollections(globalBeforeInterceptors);
        RequestHandlerProxy._releaseResourceCollections(globalExceptionInterceptors);
        RequestHandlerProxy._releaseResourceCollections(globalFinallyInterceptors);
        RequestHandlerProxy._releaseResourceCollections(globalFreeStyleInterceptors);
        globalFreeStyleInterceptor.destroy();
        globalFreeStyleInterceptor = new GroupInterceptorMetaInfo();
    }

    private static void _releaseResourceCollections(Collection<? extends Destroyable> col) {
        Destroyable.Util.destroyAll(col, null);
        col.clear();
    }

    public String controller() {
        return this.controllerClassName;
    }

    public String action() {
        return this.actionMethodName;
    }

    public ControllerAction actionHandler() {
        this.ensureAgentsReady();
        return this.actionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(ActionContext context) {
        this.ensureAgentsReady();
        context.handlerMethod(this.actionMethod);
        if (null != this.webSocketConnectionHandler) {
            this.webSocketConnectionHandler.handle(context);
            return;
        }
        Result result = null;
        try {
            H.Method method = context.req().method();
            boolean supportCache = this.supportCache && method == H.Method.GET || this.cacheSupport.supportPost && method == H.Method.POST;
            String cacheKey = null;
            if (supportCache) {
                cacheKey = this.cacheSupport.cacheKey(context);
                ResponseCache cached = (ResponseCache)this.cache.get(cacheKey);
                if (null != cached) {
                    cached.applyTo(context.prepareRespForWrite());
                    return;
                }
                context.enableCache();
            }
            this.saveActionPath(context);
            context.startIntercepting();
            result = this.handleBefore(context);
            if (null == result) {
                context.startHandling();
                result = this._handle(context);
            }
            if (context.resp().isClosed()) {
                return;
            }
            context.startIntercepting();
            Result afterResult = this.handleAfter(result, context);
            if (null != afterResult) {
                result = afterResult;
            }
            if (null == result) {
                result = context.nullValueResult();
            }
            this.onResult(result, context);
            if (!supportCache) return;
            this.cache.put(cacheKey, context.resp(), this.cacheSupport.ttl);
            return;
        }
        catch (Exception e) {
            H.Request req = context.req();
            logger.error((Throwable)e, S.concat((String)"Error handling request: [", (String)req.method().name(), (String)"] ", (String)req.url()));
            try {
                result = this.handleException(e, context);
            }
            catch (Exception e0) {
                logger.error((Throwable)e0, "Error invoking exception handler");
            }
            if (null == result) {
                result = ActErrorResult.of(e);
            }
            try {
                this.onResult(result, context);
                return;
            }
            catch (Exception e2) {
                logger.error((Throwable)e2, "error rendering exception handle  result");
                this.onResult(ActErrorResult.of(e2), context);
                return;
            }
        }
        finally {
            try {
                this.handleFinally(context);
            }
            catch (Exception e) {
                logger.error((Throwable)e, "Error invoking final handler");
            }
            finally {
                context.destroy();
            }
        }
    }

    @Override
    public boolean sessionFree() {
        this.ensureAgentsReady();
        return this.sessionFree;
    }

    @Override
    public void prepareAuthentication(ActionContext context) {
        if (null != this.missingAuthenticationHandler) {
            context.forceMissingAuthenticationHandler(this.missingAuthenticationHandler);
        }
        if (null != this.csrfFailureHandler) {
            context.forceCsrfCheckingFailureHandler(this.csrfFailureHandler);
        }
    }

    @Override
    public boolean express(ActionContext context) {
        return this.express;
    }

    protected final void registerBeforeInterceptor(BeforeInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.beforeInterceptors, interceptor);
    }

    protected final void registerAfterInterceptor(AfterInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.afterInterceptors, interceptor);
    }

    protected final void registerExceptionInterceptor(ExceptionInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.exceptionInterceptors, interceptor);
    }

    protected final void registerFinallyInterceptor(FinallyInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.finallyInterceptors, interceptor);
    }

    private void onResult(Result result, ActionContext context) {
        context.dissolve();
        boolean isRenderAny = false;
        try {
            if (result instanceof RenderAny) {
                RenderAny any = (RenderAny)result;
                isRenderAny = true;
                any.apply(context);
            } else {
                H.Request req = context.req();
                ActResponse<?> resp = context.prepareRespForWrite();
                if (result instanceof ErrorResult) {
                    resp.contentType(req.accept());
                }
                result.apply(req, resp);
            }
        }
        catch (RuntimeException e) {
            context.cacheTemplate(null);
            throw e;
        }
        finally {
            if (isRenderAny) {
                RenderAny.clearThreadLocals();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAgentsReady() {
        if (null == this.actionHandler) {
            RequestHandlerProxy requestHandlerProxy = this;
            synchronized (requestHandlerProxy) {
                if (null == this.actionHandler) {
                    this.generateHandlers();
                }
            }
        }
    }

    private void saveActionPath(ActionContext context) {
        context.actionPath(this.actionPath);
    }

    private boolean matches(Set<String> patterns) {
        if (patterns.contains(this.actionMethodName) || patterns.contains(this.actionPath)) {
            return true;
        }
        for (String s : patterns) {
            if (!Pattern.compile(s).matcher(this.actionPath).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean applied(InterceptorMethodMetaInfo interceptor) {
        Set<String> blackList = interceptor.blackList();
        if (!blackList.isEmpty()) {
            return !this.matches(blackList);
        }
        Set<String> whiteList = interceptor.whiteList();
        if (!whiteList.isEmpty()) {
            return this.matches(whiteList);
        }
        return true;
    }

    private ActionMethodMetaInfo findActionInfoFromParent(ControllerClassMetaInfo ctrlInfo, String methodName) {
        ActionMethodMetaInfo actionInfo;
        ControllerClassMetaInfo parent = ctrlInfo.parent(true);
        if (null == parent) {
            throw new UnexpectedException("Cannot find action method meta info: %s", new Object[]{this.actionPath});
        }
        while (null == (actionInfo = parent.action(methodName)) && null != (parent = parent.parent(true))) {
        }
        return new ActionMethodMetaInfo((ActionMethodMetaInfo)$.notNull((Object)actionInfo), ctrlInfo);
    }

    private WebSocketConnectionHandler tryGenerateWebSocketConnectionHandler(ActionMethodMetaInfo methodInfo) {
        WebSocketConnectionHandler wsHandler = Act.network().createWebSocketConnectionHandler(methodInfo);
        return null == wsHandler || !wsHandler.isWsHandler() ? null : wsHandler;
    }

    private void generateHandlers() {
        Handler interceptor;
        ControllerClassMetaInfo ctrlInfo = this.app.classLoader().controllerClassMetaInfo(this.controllerClassName);
        ActionMethodMetaInfo actionInfo = ctrlInfo.action(this.actionMethodName);
        if (null == actionInfo) {
            actionInfo = this.findActionInfoFromParent(ctrlInfo, this.actionMethodName);
        }
        this.webSocketConnectionHandler = this.tryGenerateWebSocketConnectionHandler(actionInfo);
        Act.Mode mode = Act.mode();
        this.actionHandler = mode.createRequestHandler(actionInfo, this.app);
        this.actionMethod = this.actionHandler.invoker().invokeMethod();
        this.sessionFree = this.actionHandler.sessionFree();
        this.missingAuthenticationHandler = this.actionHandler.missingAuthenticationHandler();
        this.csrfFailureHandler = this.actionHandler.csrfFailureHandler();
        this.express = this.actionHandler.express();
        this.cacheSupport = this.actionHandler.cacheSupport();
        this.supportCache = this.cacheSupport.enabled;
        App app = this.app;
        if (this.supportCache) {
            this.cache = app.cache();
        }
        GroupInterceptorMetaInfo interceptorMetaInfo = new GroupInterceptorMetaInfo(actionInfo.interceptors());
        interceptorMetaInfo.mergeFrom(globalFreeStyleInterceptor);
        for (GroupInterceptorMetaInfo freeStyleInterceptor : globalFreeStyleInterceptors) {
            interceptorMetaInfo.mergeFrom(freeStyleInterceptor);
        }
        for (InterceptorMethodMetaInfo info : interceptorMetaInfo.beforeList()) {
            if (!this.applied(info)) continue;
            interceptor = mode.createBeforeInterceptor(info, app);
            this.beforeInterceptors.add((BeforeInterceptor)interceptor);
            this.sessionFree = this.sessionFree && interceptor.sessionFree();
            this.express = this.express && interceptor.express();
        }
        for (InterceptorMethodMetaInfo info : interceptorMetaInfo.afterList()) {
            if (!this.applied(info)) continue;
            interceptor = mode.createAfterInterceptor(info, app);
            this.afterInterceptors.add((AfterInterceptor)interceptor);
            this.sessionFree = this.sessionFree && interceptor.sessionFree();
            this.express = this.express && interceptor.express();
        }
        for (InterceptorMethodMetaInfo info : interceptorMetaInfo.catchList()) {
            if (!this.applied(info)) continue;
            interceptor = mode.createExceptionInterceptor((CatchMethodMetaInfo)info, app);
            this.exceptionInterceptors.add((ExceptionInterceptor)interceptor);
            this.sessionFree = this.sessionFree && interceptor.sessionFree();
            this.express = this.express && interceptor.express();
        }
        Collections.sort(this.exceptionInterceptors);
        for (InterceptorMethodMetaInfo info : interceptorMetaInfo.finallyList()) {
            if (!this.applied(info)) continue;
            interceptor = mode.createFinallyInterceptor(info, app);
            this.finallyInterceptors.add((FinallyInterceptor)interceptor);
            this.sessionFree = this.sessionFree && interceptor.sessionFree();
            this.express = this.express && interceptor.express();
        }
    }

    public void accept(Handler.Visitor visitor) {
        this.ensureAgentsReady();
        for (BeforeInterceptor beforeInterceptor : globalBeforeInterceptors) {
            beforeInterceptor.accept(visitor);
        }
        for (BeforeInterceptor beforeInterceptor : this.beforeInterceptors) {
            beforeInterceptor.accept(visitor);
        }
        this.actionHandler.accept(visitor);
        for (AfterInterceptor afterInterceptor : this.afterInterceptors) {
            afterInterceptor.accept(visitor);
        }
        for (AfterInterceptor afterInterceptor : globalAfterInterceptors) {
            afterInterceptor.accept(visitor);
        }
        for (FinallyInterceptor finallyInterceptor : this.finallyInterceptors) {
            finallyInterceptor.accept(visitor);
        }
        for (FinallyInterceptor finallyInterceptor : globalFinallyInterceptors) {
            finallyInterceptor.accept(visitor);
        }
        for (ExceptionInterceptor exceptionInterceptor : this.exceptionInterceptors) {
            exceptionInterceptor.accept(visitor);
        }
        for (ExceptionInterceptor exceptionInterceptor : globalExceptionInterceptors) {
            exceptionInterceptor.accept(visitor);
        }
    }

    @Override
    public CSRF.Spec csrfSpec() {
        this.ensureAgentsReady();
        return this.actionHandler.csrfSpec();
    }

    @Override
    public String contentSecurityPolicy() {
        this.ensureAgentsReady();
        return this.actionHandler.contentSecurityPolicy();
    }

    @Override
    public boolean disableContentSecurityPolicy() {
        this.ensureAgentsReady();
        return this.actionHandler.disableContentSecurityPolicy();
    }

    @Override
    public CORS.Spec corsSpec() {
        this.ensureAgentsReady();
        return this.actionHandler.corsSpec();
    }

    private Result handleBefore(ActionContext actionContext) throws Exception {
        Result r = GLOBAL_BEFORE_INTERCEPTOR.apply(actionContext);
        if (null == r) {
            r = this.appInterceptor.handleBefore(actionContext);
        }
        if (null == r) {
            r = this.BEFORE_INTERCEPTOR.apply(actionContext);
        }
        return r;
    }

    private Result _handle(ActionContext actionContext) throws Exception {
        try {
            return this.actionHandler.handle(actionContext);
        }
        catch (Result r) {
            return r;
        }
    }

    private Result handleAfter(Result result, ActionContext actionContext) throws Exception {
        result = this.AFTER_INTERCEPTOR.apply(result, actionContext);
        result = this.appInterceptor.handleAfter(result, actionContext);
        result = GLOBAL_AFTER_INTERCEPTOR.apply(result, actionContext);
        return result;
    }

    private void handleFinally(ActionContext actionContext) throws Exception {
        this.FINALLY_INTERCEPTOR.apply(actionContext);
        this.appInterceptor.handleFinally(actionContext);
        GLOBAL_FINALLY_INTERCEPTOR.apply(actionContext);
    }

    private Result handleException(Exception ex, ActionContext actionContext) throws Exception {
        Result r = this.EXCEPTION_INTERCEPTOR.apply(ex, actionContext);
        if (null == r) {
            r = this.appInterceptor.handleException(ex, actionContext);
        }
        if (null == r) {
            r = GLOBAL_EXCEPTION_INTERCEPTOR.apply(ex, actionContext);
        }
        return r;
    }

    @Override
    public String toString() {
        return this.actionPath;
    }

    public static void registerGlobalInterceptor(GroupInterceptorMetaInfo freeStyleInterceptor) {
        globalFreeStyleInterceptors.add(freeStyleInterceptor);
    }

    public static void registerGlobalInterceptor(InterceptorMethodMetaInfo interceptor, InterceptorType type) {
        globalFreeStyleInterceptor.add(interceptor, type);
    }

    public static void registerGlobalInterceptor(BeforeInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(globalBeforeInterceptors, interceptor);
    }

    public static void registerGlobalInterceptor(AfterInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(globalAfterInterceptors, interceptor);
    }

    public static void registerGlobalInterceptor(FinallyInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(globalFinallyInterceptors, interceptor);
    }

    public static void registerGlobalInterceptor(ExceptionInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(globalExceptionInterceptors, interceptor);
        Collections.sort(globalExceptionInterceptors);
    }

    @AnnotatedClassFinder(value=Global.class, callOn=SysEventId.PRE_START)
    public static void registerGlobalInterceptors(Class<?> interceptorClass) {
        App app = Act.app();
        if (BeforeInterceptor.class.isAssignableFrom(interceptorClass)) {
            BeforeInterceptor interceptor = (BeforeInterceptor)app.getInstance(interceptorClass);
            RequestHandlerProxy.registerGlobalInterceptor(interceptor);
        } else if (AfterInterceptor.class.isAssignableFrom(interceptorClass)) {
            AfterInterceptor interceptor = (AfterInterceptor)app.getInstance(interceptorClass);
            RequestHandlerProxy.registerGlobalInterceptor(interceptor);
        } else if (ExceptionInterceptor.class.isAssignableFrom(interceptorClass)) {
            ExceptionInterceptor interceptor = (ExceptionInterceptor)app.getInstance(interceptorClass);
            RequestHandlerProxy.registerGlobalInterceptor(interceptor);
        } else if (FinallyInterceptor.class.isAssignableFrom(interceptorClass)) {
            FinallyInterceptor interceptor = (FinallyInterceptor)app.getInstance(interceptorClass);
            RequestHandlerProxy.registerGlobalInterceptor(interceptor);
        } else {
            ControllerClassMetaInfo metaInfo = app.classLoader().controllerClassMetaInfo(interceptorClass.getName());
            if (null != metaInfo) {
                RequestHandlerProxy.registerGlobalInterceptor(metaInfo.interceptors());
            }
        }
    }

    public static <T extends Handler> void insertInterceptor(List<T> list, T i) {
        int sz = list.size();
        if (0 == sz) {
            list.add(i);
        }
        ListIterator<T> itr = list.listIterator();
        while (itr.hasNext()) {
            Handler t = (Handler)itr.next();
            int n = i.compareTo((Handler)t);
            if (n < 0) {
                itr.add(i);
                return;
            }
            if (n != 0) continue;
            if (i.equals(t)) {
                return;
            }
            itr.add(i);
            return;
        }
        list.add(i);
    }

    public static class GroupExceptionInterceptor {
        private List<? extends ExceptionInterceptor> interceptors;

        public GroupExceptionInterceptor(List<? extends ExceptionInterceptor> interceptors) {
            this.interceptors = interceptors;
        }

        public Result apply(Exception e, ActionContext actionContext) throws Exception {
            try {
                if (this.interceptors.isEmpty()) {
                    return null;
                }
                for (ExceptionInterceptor exceptionInterceptor : this.interceptors) {
                    Result r = exceptionInterceptor.handle(e, actionContext);
                    if (null == r) continue;
                    return r;
                }
                return null;
            }
            catch (Result r) {
                return r;
            }
        }
    }

    public static class GroupFinallyInterceptor {
        private List<? extends FinallyInterceptor> interceptors;

        public GroupFinallyInterceptor(List<FinallyInterceptor> interceptors) {
            this.interceptors = interceptors;
        }

        public Void apply(ActionContext actionContext) throws Exception {
            if (this.interceptors.isEmpty()) {
                return null;
            }
            for (FinallyInterceptor finallyInterceptor : this.interceptors) {
                finallyInterceptor.handle(actionContext);
            }
            return null;
        }
    }

    public static class GroupAfterInterceptor {
        private List<? extends AfterInterceptor> interceptors;

        public GroupAfterInterceptor(List<? extends AfterInterceptor> interceptors) {
            this.interceptors = interceptors;
        }

        public Result apply(Result result, ActionContext actionContext) throws Exception {
            for (AfterInterceptor afterInterceptor : this.interceptors) {
                result = afterInterceptor.handle(result, actionContext);
            }
            return result;
        }
    }

    public static class GroupInterceptorWithResult {
        private List<? extends ActionHandler> interceptors;

        public GroupInterceptorWithResult(List<? extends ActionHandler> interceptors) {
            this.interceptors = interceptors;
        }

        public Result apply(ActionContext actionContext) throws Exception {
            try {
                if (this.interceptors.isEmpty()) {
                    return null;
                }
                for (ActionHandler actionHandler : this.interceptors) {
                    Result r = actionHandler.handle(actionContext);
                    if (null == r) continue;
                    return r;
                }
                return null;
            }
            catch (Result r) {
                return r;
            }
        }
    }
}

