/*
 * Decompiled with CFR 0.152.
 */
package act.i18n;

import act.Act;
import act.act_messages;
import act.util.ActContext;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.S;

public class I18n {
    private static final Logger logger = LogManager.get(I18n.class);
    public static final String DEF_RESOURCE_BUNDLE_NAME = "messages";
    private static Set<String> standardsAnnotationMethods = C.newSet((Collection)C.list((Object)"declaringClass", (Object[])new String[]{"hashCode", "toString", "ordinal", "name", "class"}));
    private static ConcurrentMap<Class<? extends Enum>, Map<String, Lang.Function<Object, Object>>> enumPropertyGetterCache = new ConcurrentHashMap<Class<? extends Enum>, Map<String, Lang.Function<Object, Object>>>();

    public static Locale locale() {
        ActContext.Base<?> context = ActContext.Base.currentContext();
        return null != context ? context.locale(true) : Act.appConfig().locale();
    }

    public static String i18n(String msgId, Object ... args) {
        return I18n._i18n(true, I18n.locale(), DEF_RESOURCE_BUNDLE_NAME, msgId, args);
    }

    public static String i18n(boolean ignoreError, String msgId, Object ... args) {
        return I18n._i18n(ignoreError, I18n.locale(), DEF_RESOURCE_BUNDLE_NAME, msgId, args);
    }

    public static String i18n(Locale locale, String msgId, Object ... args) {
        return I18n._i18n(true, locale, DEF_RESOURCE_BUNDLE_NAME, msgId, args);
    }

    public static String i18n(boolean ignoreError, Locale locale, String msgId, Object ... args) {
        return I18n._i18n(ignoreError, locale, DEF_RESOURCE_BUNDLE_NAME, msgId, args);
    }

    public static String i18n(Class<?> bundleSpec, String msgId, Object ... args) {
        return I18n._i18n(true, I18n.locale(), bundleSpec.getName(), msgId, args);
    }

    public static String i18n(boolean ignoreError, Class<?> bundleSpec, String msgId, Object ... args) {
        return I18n._i18n(ignoreError, I18n.locale(), bundleSpec.getName(), msgId, args);
    }

    public static String i18n(Locale locale, Class<?> bundleSpec, String msgId, Object ... args) {
        return I18n._i18n(true, locale, bundleSpec.getName(), msgId, args);
    }

    public static String i18n(boolean ignoreError, Locale locale, Class<?> bundleSpec, String msgId, Object ... args) {
        return I18n._i18n(ignoreError, locale, bundleSpec.getName(), msgId, args);
    }

    private static String _i18n(boolean ignoreError, Locale locale, String bundleName, String msgId, Object ... args) {
        int len;
        ResourceBundle bundle;
        if (null == msgId) {
            return "";
        }
        if (bundleName.startsWith("act.")) {
            bundleName = act_messages.class.getName();
        }
        try {
            bundle = ResourceBundle.getBundle(bundleName, (Locale)$.notNull((Object)locale), Act.app().classLoader());
        }
        catch (MissingResourceException e) {
            return msgId;
        }
        String msg = msgId;
        if (ignoreError) {
            if (bundle.containsKey(msgId)) {
                msg = bundle.getString(msgId);
            }
        } else {
            try {
                msg = bundle.getString(msgId);
            }
            catch (MissingResourceException e) {
                logger.warn("Cannot find i18n message key: %s", new Object[]{msgId});
            }
        }
        if ((len = args.length) > 0) {
            Object[] resolvedArgs = new Object[len];
            for (int i = 0; i < len; ++i) {
                Object arg = args[i];
                resolvedArgs[i] = arg instanceof String ? I18n._i18n(true, locale, bundleName, (String)arg, new Object[0]) : arg;
            }
            MessageFormat formatter = new MessageFormat(msg, locale);
            msg = formatter.format(resolvedArgs);
        }
        return msg;
    }

    public static String i18n(Enum<?> msgId) {
        return I18n.i18n(I18n.locale(), msgId);
    }

    public static String i18n(Locale locale, Enum<?> msgId) {
        return I18n.i18n(locale, DEF_RESOURCE_BUNDLE_NAME, msgId);
    }

    public static String i18n(Class<?> bundleSpec, Enum<?> msgId) {
        return I18n.i18n(I18n.locale(), bundleSpec, msgId);
    }

    public static String i18n(Locale locale, Class<?> bundleSpec, Enum<?> msgId) {
        return I18n.i18n(true, locale, bundleSpec.getName(), msgId);
    }

    public static String i18n(Locale locale, String bundleName, Enum<?> msgId) {
        String resolved;
        String key = S.newBuffer((String)"enum.").append(S.underscore((CharSequence)msgId.getDeclaringClass().getSimpleName())).append(".").append(msgId.name().toLowerCase()).toString();
        if (key == (resolved = I18n._i18n(true, locale, bundleName, key, new Object[0])) || S.blank((String)resolved)) {
            key = S.newBuffer((String)"enum.").append(msgId.getDeclaringClass().getSimpleName().toLowerCase()).append(".").append(msgId.name().toLowerCase()).toString();
            resolved = I18n._i18n(true, locale, bundleName, key, new Object[0]);
        }
        return resolved;
    }

    public static Map<String, Object> i18n(Class<? extends Enum> enumClass) {
        return I18n.i18n(I18n.locale(), enumClass);
    }

    public static Map<String, Object> i18n(Locale locale, Class<? extends Enum> enumClass) {
        return I18n.i18n(locale, DEF_RESOURCE_BUNDLE_NAME, enumClass);
    }

    public static Map<String, Object> i18n(Class<?> bundleSpec, Class<? extends Enum> enumClass) {
        return I18n.i18n(I18n.locale(), bundleSpec, enumClass);
    }

    public static Map<String, Object> i18n(Locale locale, Class<?> bundleSpec, Class<? extends Enum> enumClass) {
        return I18n.i18n(locale, bundleSpec.getName(), enumClass);
    }

    public static Map<String, Object> i18n(Locale locale, String bundleName, Class<? extends Enum> enumClass) {
        return I18n.i18n(locale, bundleName, enumClass, false);
    }

    public static Map<String, Object> i18n(Class<? extends Enum> enumClass, boolean outputProperties) {
        return I18n.i18n(I18n.locale(), enumClass, outputProperties);
    }

    public static Map<String, Object> i18n(Locale locale, Class<? extends Enum> enumClass, boolean outputProperties) {
        return I18n.i18n(locale, DEF_RESOURCE_BUNDLE_NAME, enumClass, outputProperties);
    }

    public static Map<String, Object> i18n(Class<?> bundleSpec, Class<? extends Enum> enumClass, boolean outputProperties) {
        return I18n.i18n(I18n.locale(), bundleSpec, enumClass, outputProperties);
    }

    public static Map<String, Object> i18n(Locale locale, Class<?> bundleSpec, Class<? extends Enum> enumClass, boolean outputProperties) {
        return I18n.i18n(locale, bundleSpec.getName(), enumClass, outputProperties);
    }

    public static Map<String, Object> i18n(Locale locale, String bundleName, Class<? extends Enum> enumClass, boolean outputProperties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Enum enumInstance : enumClass.getEnumConstants()) {
            String name = enumInstance.name();
            String val = I18n.i18n(locale, bundleName, enumInstance);
            if (outputProperties) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                map.put(name, values);
                values.put("message", val);
                Map<String, Lang.Function<Object, Object>> getters = I18n.enumPropertyGetters(enumClass);
                for (Map.Entry<String, Lang.Function<Object, Object>> entry : getters.entrySet()) {
                    values.put(entry.getKey(), entry.getValue().apply((Object)enumInstance));
                }
                continue;
            }
            map.put(name, val);
        }
        return map;
    }

    private static Map<String, Lang.Function<Object, Object>> enumPropertyGetters(Class<? extends Enum> enumClass) {
        Map<String, Lang.Function<Object, Object>> newMap;
        Map<String, Lang.Function<Object, Object>> map = (Map<String, Lang.Function<Object, Object>>)enumPropertyGetterCache.get(enumClass);
        if (null == map && null == (map = enumPropertyGetterCache.putIfAbsent(enumClass, newMap = I18n.buildEnumPropertyGetters(enumClass)))) {
            map = newMap;
        }
        return map;
    }

    private static Map<String, Lang.Function<Object, Object>> buildEnumPropertyGetters(Class<? extends Enum> enumClass) {
        HashMap<String, Lang.Function<Object, Object>> map = new HashMap<String, Lang.Function<Object, Object>>();
        for (final Method method : enumClass.getMethods()) {
            String name;
            if (Void.TYPE == method.getReturnType() || Void.class == method.getReturnType() || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length > 0 || standardsAnnotationMethods.contains(name = I18n.propertyName(method))) continue;
            map.put(method.getName(), new Lang.Function<Object, Object>(){

                public Object apply(Object o) throws NotAppliedException, Lang.Break {
                    return $.invokeVirtual((Object)o, (Method)method, (Object[])new Object[0]);
                }
            });
        }
        return map;
    }

    private static String propertyName(Method method) {
        String name = method.getName();
        int len = name.length();
        if (len > 3 && name.startsWith("get")) {
            name = S.lowerFirst((String)name.substring(3));
        } else if (len > 2 && name.startsWith("is")) {
            name = S.lowerFirst((String)name.substring(2));
        }
        return name;
    }
}

