/*
 * Decompiled with CFR 0.152.
 */
package act.inject;

import act.Destroyable;
import act.app.App;
import act.app.AppClassLoader;
import act.app.AppServiceBase;
import act.app.event.SysEventId;
import act.inject.ActProviders;
import act.inject.DependencyInjectionBinder;
import act.inject.DependencyInjectionListener;
import act.inject.DependencyInjector;
import act.util.ClassNode;
import act.util.SubClassFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.inject.BeanSpec;

public abstract class DependencyInjectorBase<DI extends DependencyInjectorBase<DI>>
extends AppServiceBase<DI>
implements DependencyInjector<DI> {
    protected Map<Class, DependencyInjectionBinder> binders = new HashMap<Class, DependencyInjectionBinder>();
    protected Map<Class, List<DependencyInjectionListener>> listeners = new HashMap<Class, List<DependencyInjectionListener>>();

    public DependencyInjectorBase(App app) {
        this(app, false);
    }

    protected DependencyInjectorBase(App app, boolean noRegister) {
        super(app, true);
        if (!noRegister) {
            app.injector(this);
        }
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.binders.values(), ApplicationScoped.class);
        this.binders.clear();
    }

    @Override
    public synchronized void registerDiBinder(DependencyInjectionBinder binder) {
        this.binders.put(binder.targetClass(), binder);
        ActProviders.addProvidedType(binder.targetClass());
    }

    @Override
    public synchronized void registerDiListener(DependencyInjectionListener listener) {
        Class[] targets;
        for (Class c : targets = listener.listenTo()) {
            List<DependencyInjectionListener> list = this.listeners.get(c);
            if (null == list) {
                final ArrayList<DependencyInjectionListener> list0 = new ArrayList<DependencyInjectionListener>();
                list = list0;
                final AppClassLoader cl = this.app().classLoader();
                ClassNode node = cl.classInfoRepository().node(c.getName());
                node.visitPublicNotAbstractTreeNodes(new Lang.Visitor<ClassNode>(){

                    public void visit(ClassNode classNode) throws Lang.Break {
                        DependencyInjectorBase.this.listeners.put($.classForName((String)classNode.name(), (ClassLoader)cl), list0);
                    }
                });
                this.listeners.put(c, list);
            }
            list.add(listener);
        }
    }

    @Override
    public void fireInjectedEvent(Object bean, BeanSpec spec) {
        Class c = spec.rawType();
        List<DependencyInjectionListener> list = this.listeners.get(c);
        if (null != list) {
            for (DependencyInjectionListener listener : list) {
                listener.onInjection(bean, spec);
            }
        }
    }

    @SubClassFinder(value=DependencyInjectionListener.class, callOn=SysEventId.DEPENDENCY_INJECTOR_PROVISIONED)
    public static void discoverDiListener(Class<? extends DependencyInjectionListener> target) {
        App app = App.instance();
        Object di = app.injector();
        di.registerDiListener(app.getInstance(target));
    }
}

