/*
 * Decompiled with CFR 0.152.
 */
package act.inject.genie;

import act.app.AppByteCodeScannerBase;
import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import java.util.HashSet;
import java.util.Set;
import org.osgl.inject.Module;

public class GenieFactoryFinder
extends AppByteCodeScannerBase {
    private static Set<String> factories = new HashSet<String>();
    private boolean isFactory;
    private boolean isModule;

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new ByteCodeVisitor(){
            private boolean isPublic;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.isPublic = AsmTypes.isPublic(access);
                GenieFactoryFinder.this.isModule = Module.class.getName().equals(Type.getObjectType((String)superName).getClassName());
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return !this.isPublic || GenieFactoryFinder.this.isModule || GenieFactoryFinder.this.isFactory ? mv : new MethodVisitor(327680, mv){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        Type annoType = Type.getType((String)desc);
                        if (AsmTypes.PROVIDES.asmType().equals((Object)annoType)) {
                            GenieFactoryFinder.this.isFactory = true;
                        }
                        return super.visitAnnotation(desc, visible);
                    }
                };
            }
        };
    }

    @Override
    public void scanFinished(String className) {
        if (this.isFactory) {
            factories.add(className);
        }
    }

    @Override
    protected boolean shouldScan(String className) {
        return true;
    }

    static Set<String> factories() {
        return factories;
    }
}

