/*
 * Decompiled with CFR 0.152.
 */
package act.inject.genie;

import act.Act;
import act.app.App;
import act.app.AppClassLoader;
import act.app.conf.AppConfigurator;
import act.app.event.SysEventId;
import act.controller.ActionMethodParamAnnotationHandler;
import act.inject.ActProvider;
import act.inject.ActProviders;
import act.inject.AutoBind;
import act.inject.Context;
import act.inject.DependencyInjectionBinder;
import act.inject.DependencyInjectorBase;
import act.inject.ModuleTag;
import act.inject.genie.GenieFactoryFinder;
import act.inject.genie.GenieListener;
import act.inject.genie.GenieProviders;
import act.inject.genie.RequestScope;
import act.inject.genie.SessionScope;
import act.inject.genie.SingletonScope;
import act.sys.Env;
import act.util.AnnotatedClassFinder;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import act.util.InheritedStateless;
import act.util.SingletonBase;
import act.util.Stateful;
import act.util.Stateless;
import act.util.SubClassFinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.ConfigurationException;
import org.osgl.exception.NotAppliedException;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.GenericTypedBeanLoader;
import org.osgl.inject.Genie;
import org.osgl.inject.InjectListener;
import org.osgl.inject.Injector;
import org.osgl.inject.Module;
import org.osgl.inject.NamedProvider;
import org.osgl.inject.ScopeCache;
import org.osgl.inject.annotation.LoadValue;
import org.osgl.inject.annotation.Provided;
import org.osgl.inject.annotation.StopInheritedScope;
import org.osgl.mvc.annotation.Bind;
import org.osgl.mvc.annotation.Param;
import org.osgl.util.E;

public class GenieInjector
extends DependencyInjectorBase<GenieInjector> {
    private static final Module SCOPE_MODULE = new Module(){

        protected void configure() {
            this.bind(ScopeCache.SessionScope.class).to((Object)new SessionScope());
            this.bind(ScopeCache.RequestScope.class).to((Object)new RequestScope());
            this.bind(ScopeCache.SingletonScope.class).to((Object)new SingletonScope());
        }
    };
    private volatile Genie genie;
    private Set<Object> modules;
    private Set<Class<? extends Annotation>> injectTags = new HashSet<Class<? extends Annotation>>();

    public GenieInjector(App app) {
        super(app);
        this.modules = new LinkedHashSet<Object>();
        this.modules.add(SCOPE_MODULE);
        this.modules.addAll(this.factories());
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return (T)this.genie().get(clazz);
    }

    public <T> Provider<T> getProvider(Class<T> aClass) {
        return this.genie().getProvider(aClass);
    }

    public <T> T get(BeanSpec spec) {
        return (T)this.genie().get(spec);
    }

    @Override
    public synchronized void registerDiBinder(DependencyInjectionBinder binder) {
        super.registerDiBinder(binder);
        if (null != this.genie) {
            this.genie.registerProvider(binder.targetClass(), (Provider)binder);
        }
    }

    @Override
    public <T> void registerProvider(Class<? super T> type, Provider<? extends T> provider) {
        this.genie().registerProvider(type, provider);
    }

    @Override
    public <T> void registerNamedProvider(Class<? super T> type, NamedProvider<? extends T> provider) {
        this.genie().registerNamedProvider(type, provider);
    }

    @Override
    public boolean isProvided(Class<?> type) {
        return !$.isSimpleType(type) && ActProviders.isProvided(type) || type.isAnnotationPresent(Provided.class) || type.isAnnotationPresent(Inject.class) || type.isAnnotationPresent(Singleton.class) || SingletonBase.class.isAssignableFrom(type);
    }

    public boolean isProvided(BeanSpec beanSpec) {
        Class rawType = beanSpec.rawType();
        boolean provided = ActProviders.isProvided(rawType) || null != beanSpec.getAnnotation(Inject.class) || null != beanSpec.getAnnotation(Provided.class) || null != beanSpec.getAnnotation(Context.class) || null != beanSpec.getAnnotation(Singleton.class) || beanSpec.isInstanceOf(SingletonBase.class) || this.subjectToInject(beanSpec);
        return provided && (!$.isSimpleType((Class)rawType) || beanSpec.hasAnnotation());
    }

    private boolean isPureSimpleType(BeanSpec spec, Class<?> rawType) {
        return $.isSimpleType(rawType) && spec.qualifiers().isEmpty();
    }

    public boolean isQualifier(Class<? extends Annotation> aClass) {
        return this.genie().isQualifier(aClass);
    }

    public boolean isPostConstructProcessor(Class<? extends Annotation> aClass) {
        return this.genie().isPostConstructProcessor(aClass);
    }

    public boolean isScope(Class<? extends Annotation> annoClass) {
        return this.genie().isScope(annoClass);
    }

    public boolean isInheritedScopeStopper(Class<? extends Annotation> annoClass) {
        return this.genie().isInheritedScopeStopper(annoClass);
    }

    public Class<? extends Annotation> scopeByAlias(Class<? extends Annotation> aClass) {
        return this.genie().scopeByAlias(aClass);
    }

    public void addModule(Object module) {
        E.illegalStateIf((null != this.genie ? 1 : 0) != 0);
        this.modules.add(module);
    }

    public boolean subjectToInject(BeanSpec spec) {
        return this.app().isSingleton(spec.rawType()) || this.genie().subjectToInject(spec);
    }

    private Set<Object> factories() {
        Set<String> factories = GenieFactoryFinder.factories();
        int len = factories.size();
        HashSet<Object> set = new HashSet<Object>();
        if (0 == len) {
            return set;
        }
        AppClassLoader cl = App.instance().classLoader();
        for (String className : factories) {
            set.add($.classForName((String)className, (ClassLoader)cl));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Genie genie() {
        if (null == this.genie) {
            GenieInjector genieInjector = this;
            synchronized (genieInjector) {
                if (null == this.genie) {
                    GenieListener listener = new GenieListener(this);
                    this.genie = Genie.create((InjectListener)listener, (Object[])this.modules.toArray(new Object[this.modules.size()]));
                    for (Map.Entry entry : this.binders.entrySet()) {
                        this.genie.registerProvider((Class)entry.getKey(), (Provider)entry.getValue());
                    }
                    Lang.F2<Class, NamedProvider, Void> namedProviderRegister = new Lang.F2<Class, NamedProvider, Void>(){

                        public Void apply(Class aClass, NamedProvider namedProvider) throws NotAppliedException, Lang.Break {
                            GenieInjector.this.genie.registerNamedProvider(aClass, namedProvider);
                            return null;
                        }
                    };
                    Lang.F2<Class, Provider, Void> register = new Lang.F2<Class, Provider, Void>(){

                        public Void apply(Class aClass, Provider provider) throws NotAppliedException, Lang.Break {
                            GenieInjector.this.genie.registerProvider(aClass, provider);
                            return null;
                        }
                    };
                    this.genie.registerQualifiers(new Class[]{Bind.class, Param.class});
                    this.genie.registerScopeAlias(Singleton.class, Stateless.class);
                    this.genie.registerScopeAlias(Singleton.class, InheritedStateless.class);
                    this.genie.registerScopeAlias(StopInheritedScope.class, Stateful.class);
                    List<ActionMethodParamAnnotationHandler> list = Act.pluginManager().pluginList(ActionMethodParamAnnotationHandler.class);
                    for (ActionMethodParamAnnotationHandler actionMethodParamAnnotationHandler : list) {
                        Set<Class<? extends Annotation>> set = actionMethodParamAnnotationHandler.listenTo();
                        for (Class<? extends Annotation> c : set) {
                            this.genie.registerQualifiers(new Class[]{c});
                        }
                    }
                    ActProviders.registerBuiltInProviders(ActProviders.class, register);
                    ActProviders.registerBuiltInProviders(GenieProviders.class, register);
                    ActProviders.registerBuiltInNamedProviders(ActProviders.class, namedProviderRegister);
                    ActProviders.registerBuiltInNamedProviders(GenieProviders.class, namedProviderRegister);
                    for (Class clazz : this.injectTags) {
                        this.genie.registerInjectTag(new Class[]{clazz});
                    }
                    this.genie.registerProvider(Genie.class, (Provider)new Provider<Genie>(){

                        public Genie get() {
                            return GenieInjector.this.genie;
                        }
                    });
                }
            }
        }
        return this.genie;
    }

    @SubClassFinder(callOn=SysEventId.DEPENDENCY_INJECTOR_LOADED)
    public static void foundModule(Class<? extends Module> moduleClass) {
        GenieInjector.addModuleClass(moduleClass);
    }

    @SubClassFinder(callOn=SysEventId.DEPENDENCY_INJECTOR_LOADED)
    public static void foundConfigurator(Class<? extends AppConfigurator> configurator) {
        GenieInjector.addModuleClass(configurator);
    }

    private static boolean hasBinding(Class<?> clazz) {
        GenieInjector gi = (GenieInjector)Act.injector();
        Genie genie = gi.genie();
        return genie.hasProvider(clazz);
    }

    @AnnotatedClassFinder(value=AutoBind.class, callOn=SysEventId.DEPENDENCY_INJECTOR_PROVISIONED, noAbstract=false)
    public static void foundAutoBinding(final Class<?> autoBinding) {
        if (GenieInjector.hasBinding(autoBinding)) {
            return;
        }
        final AppClassLoader cl = Act.app().classLoader();
        ClassInfoRepository repo = cl.classInfoRepository();
        ClassNode root = repo.node(autoBinding.getName());
        E.invalidConfigurationIf((null == root ? 1 : 0) != 0, (String)"Cannot find AutoBind root: %s", (Object[])new Object[]{autoBinding.getName()});
        final LinkedHashSet candidates = new LinkedHashSet();
        root.visitPublicNotAbstractSubTreeNodes(new Lang.Visitor<ClassNode>(){

            public void visit(ClassNode classNode) throws Lang.Break {
                try {
                    Class clazz = $.classForName((String)classNode.name(), (ClassLoader)cl);
                    if (Env.matches(clazz)) {
                        candidates.add(clazz);
                    }
                }
                catch (ConfigurationException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new ConfigurationException((Throwable)e, "Unable to auto bind on %s", new Object[]{autoBinding.getName()});
                }
            }
        });
        if (!candidates.isEmpty()) {
            GenieInjector injector = (GenieInjector)Act.app().injector();
            HashMap<Lang.T2, Class> multiCandidatesMap = new HashMap<Lang.T2, Class>();
            for (Class clazz : candidates) {
                String name;
                BeanSpec spec = BeanSpec.of((Class)clazz, (Injector)injector);
                Set qualifiers = spec.qualifiers();
                Lang.T2 key = $.T2((Object)qualifiers, (Object)(name = spec.name()));
                if (multiCandidatesMap.containsKey(key)) {
                    throw new ConfigurationException("Unable to auto bind on %s: multiple same qualified candidates found", new Object[]{autoBinding});
                }
                multiCandidatesMap.put(key, clazz);
            }
            for (Map.Entry entry : multiCandidatesMap.entrySet()) {
                Genie.Binder binder = new Genie.Binder(autoBinding).to((Class)entry.getValue());
                Lang.T2 key = (Lang.T2)entry.getKey();
                Set qualifiers = (Set)key._1;
                String name = (String)key._2;
                if (!qualifiers.isEmpty()) {
                    binder = binder.withAnnotation(qualifiers.toArray(new Annotation[qualifiers.size()]));
                }
                if (null != name) {
                    binder.named(name);
                }
                binder.register(injector.genie());
            }
        } else {
            Act.LOGGER.warn("Unable to auto bind on %s: implementation not found", new Object[]{autoBinding});
        }
    }

    @AnnotatedClassFinder(value=ModuleTag.class, callOn=SysEventId.DEPENDENCY_INJECTOR_LOADED, noAbstract=false)
    public static void foundTaggedModule(Class<?> taggedModuleClass) {
        GenieInjector.addModuleClass(taggedModuleClass);
    }

    public static void addModuleClass(Class<?> moduleClass) {
        if (!GenieInjector.isModuleAllowed(moduleClass)) {
            return;
        }
        App app = App.instance();
        GenieInjector genieInjector = (GenieInjector)app.injector();
        genieInjector.addModule(moduleClass);
    }

    @AnnotatedClassFinder(value=LoadValue.class, noAbstract=false, callOn=SysEventId.DEPENDENCY_INJECTOR_LOADED)
    public static void foundValueLoader(Class<? extends Annotation> valueLoader) {
        App app = App.instance();
        GenieInjector genieInjector = (GenieInjector)app.injector();
        genieInjector.injectTags.add(valueLoader);
    }

    @SubClassFinder
    public static void foundGenericTypedBeanLoader(Class<? extends GenericTypedBeanLoader> loaderClass) {
        Type[] ta;
        App app = App.instance();
        GenieInjector genieInjector = (GenieInjector)app.injector();
        for (Type t : ta = loaderClass.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(t instanceof ParameterizedType) || GenericTypedBeanLoader.class != (pt = (ParameterizedType)t).getRawType()) continue;
            Type compoentType = pt.getActualTypeArguments()[0];
            genieInjector.genie().registerGenericTypedBeanLoader((Class)compoentType, app.getInstance(loaderClass));
        }
    }

    @SubClassFinder
    public static void foundProviderBase(Class<? extends ActProvider> providerClass) {
        App app = App.instance();
        GenieInjector genieInjector = (GenieInjector)app.injector();
        ActProvider provider = app.getInstance(providerClass);
        genieInjector.genie().registerProvider(provider.targetType(), (Provider)provider);
    }

    private static boolean isModuleAllowed(Class<?> moduleClass) {
        return Env.matches(moduleClass);
    }
}

