/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.Act;
import act.app.App;
import act.cli.CliContext;
import act.cli.Optional;
import act.cli.Required;
import act.cli.meta.CommandMethodMetaInfo;
import act.cli.util.CommandLineParser;
import act.inject.param.CliArgumentLoader;
import act.inject.param.CliVarArgumentLoader;
import act.inject.param.OptionLoader;
import act.inject.param.ParamValueLoader;
import act.inject.param.ParamValueLoaderService;
import act.inject.param.ProvidedValueLoader;
import act.util.ActContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.UnexpectedException;
import org.osgl.http.H;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Injector;
import org.osgl.inject.util.AnnotationUtil;
import org.osgl.mvc.annotation.Resolve;
import org.osgl.util.AnnotationAware;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public class CliContextParamLoader
extends ParamValueLoaderService {
    private static final transient ThreadLocal<CommandMethodMetaInfo> methodMetaInfoHolder = new ThreadLocal();
    private ConcurrentMap<Method, List<OptionLoader>> optionLoaderRegistry = new ConcurrentHashMap<Method, List<OptionLoader>>();

    CliContextParamLoader(App app) {
        super(app);
    }

    public CliContext.ParsingContext buildParsingContext(Class commander, Method method, CommandMethodMetaInfo methodMetaInfo) {
        CliContext.ParsingContextBuilder.start();
        this.ensureOptionLoaders(method, methodMetaInfo);
        methodMetaInfoHolder.set(methodMetaInfo);
        if (!Modifier.isStatic(method.getModifiers())) {
            ParamValueLoader loader = this.findBeanLoader(commander);
            this.classRegistry.putIfAbsent(commander, loader);
        }
        Lang.Var boolBag = $.var();
        ActContext.Base<ActContext.Base> ctx = new ActContext.Base<ActContext.Base>(Act.app()){

            @Override
            public ActContext.Base accept(H.Format fmt) {
                return null;
            }

            @Override
            public H.Format accept() {
                return null;
            }

            @Override
            public String methodPath() {
                return null;
            }

            public Set<String> paramKeys() {
                return null;
            }

            public String paramVal(String key) {
                return null;
            }

            public String[] paramVals(String key) {
                return new String[0];
            }
        };
        ctx.currentMethod(method);
        ParamValueLoader[] loaders = this.findMethodParamLoaders(method, commander, ctx, (Lang.Var<Boolean>)boolBag);
        this.methodRegistry.putIfAbsent(method, loaders);
        this.methodValidationConstraintLookup.put(method, boolBag.get());
        return CliContext.ParsingContextBuilder.finish();
    }

    public void preParseOptions(Method method, CommandMethodMetaInfo methodMetaInfo, CliContext context) {
        List<OptionLoader> optionLoaders = this.ensureOptionLoaders(method, methodMetaInfo);
        CommandLineParser commandLineParser = context.commandLine();
        boolean argumentAsOption = false;
        if (1 == optionLoaders.size()) {
            String theOptionVal;
            OptionLoader loader = optionLoaders.get(0);
            if (loader.required && null != (theOptionVal = commandLineParser.argumentAsOption())) {
                argumentAsOption = true;
                context.parsingContext().foundRequired(loader.requiredGroup);
                context.param(loader.bindName, theOptionVal);
            }
        }
        if (!argumentAsOption) {
            for (OptionLoader loader : optionLoaders) {
                String bindName = loader.bindName;
                String value = commandLineParser.getString(loader.lead1, loader.lead2);
                if (!S.notBlank((String)value)) continue;
                if (loader.required) {
                    context.parsingContext().foundRequired(loader.requiredGroup);
                }
                context.param(bindName, value);
            }
        }
        context.parsingContext().raiseExceptionIfThereAreMissingOptions(context);
    }

    @Override
    protected ParamValueLoader findContextSpecificLoader(String bindName, BeanSpec spec) {
        Optional optional;
        boolean isArray = spec.isArray();
        StringValueResolver resolver = this.findResolver(spec, isArray);
        Required required = (Required)spec.getAnnotation(Required.class);
        Optional optional2 = optional = null == required ? (Optional)spec.getAnnotation(Optional.class) : null;
        if (null != required) {
            return new OptionLoader(bindName, required, resolver, spec);
        }
        if (null != optional) {
            return new OptionLoader(bindName, optional, resolver, spec);
        }
        return isArray ? new CliVarArgumentLoader(spec.rawType().getComponentType(), resolver) : new CliArgumentLoader(resolver);
    }

    private StringValueResolver findResolver(BeanSpec spec, boolean isArray) {
        StringValueResolver resolver = this.findAnnotatedResolver(spec);
        return null == resolver ? this.findImplicitResolver(spec, isArray) : resolver;
    }

    private StringValueResolver findAnnotatedResolver(BeanSpec spec) {
        StringValueResolver resolver = this.findDirectAnnotatedResolver(spec);
        return null == resolver ? this.findIndirectAnnotatedResolver(spec) : resolver;
    }

    private StringValueResolver findDirectAnnotatedResolver(BeanSpec spec) {
        Resolve resolve = (Resolve)spec.getAnnotation(Resolve.class);
        Class rawType = spec.rawType();
        if (null != resolve) {
            Class[] resolvers;
            for (Class resolverClass : resolvers = resolve.value()) {
                StringValueResolver resolver = (StringValueResolver)this.injector.get(resolverClass);
                if (!rawType.isAssignableFrom(resolver.targetType())) continue;
                return resolver;
            }
        }
        return null;
    }

    private StringValueResolver findIndirectAnnotatedResolver(BeanSpec spec) {
        Annotation[] aa = spec.allAnnotations();
        Class rawType = spec.rawType();
        for (Annotation a : aa) {
            Class[] resolvers;
            Resolve resolve = (Resolve)AnnotationUtil.tagAnnotation((Annotation)a, Resolve.class);
            if (null == resolve) continue;
            for (Class resolverClass : resolvers = resolve.value()) {
                StringValueResolver resolver = (StringValueResolver)this.injector.get(resolverClass);
                resolver.attributes($.evaluate((Annotation)a));
                if (!rawType.isAssignableFrom(resolver.targetType())) continue;
                return resolver;
            }
        }
        return null;
    }

    private StringValueResolver findImplicitResolver(BeanSpec spec, boolean isArray) {
        StringValueResolver resolver = this.resolverManager.resolver(spec.rawType(), (AnnotationAware)spec);
        if (null != resolver) {
            return resolver;
        }
        if (isArray) {
            final BeanSpec compSpec = spec.componentSpec();
            final StringValueResolver<ArrayList> colResolver = this.resolverManager.collectionResolver(ArrayList.class, compSpec.rawType(), "[,;:\\s]+");
            final boolean isPrimitive = $.isPrimitive((Class)compSpec.rawType());
            return new StringValueResolver(){

                public Object resolve(String s) {
                    List list = (List)colResolver.resolve(s);
                    int size = list.size();
                    Class compType = compSpec.rawType();
                    Object array = Array.newInstance(compType, size);
                    for (int i = 0; i < size; ++i) {
                        Object item = list.get(i);
                        if (isPrimitive) {
                            if (Boolean.TYPE == compType) {
                                Array.setBoolean(array, i, (Boolean)item);
                                continue;
                            }
                            if (Byte.TYPE == compType) {
                                Array.setByte(array, i, (Byte)item);
                                continue;
                            }
                            if (Character.TYPE == compType) {
                                Array.setChar(array, i, ((Character)item).charValue());
                                continue;
                            }
                            if (Double.TYPE == compType) {
                                Array.setDouble(array, i, (Double)item);
                                continue;
                            }
                            if (Float.TYPE == compType) {
                                Array.setFloat(array, i, ((Float)item).floatValue());
                                continue;
                            }
                            if (Integer.TYPE == compType) {
                                Array.setInt(array, i, (Integer)item);
                                continue;
                            }
                            if (Long.TYPE == compType) {
                                Array.setLong(array, i, (Long)item);
                                continue;
                            }
                            if (Short.TYPE == compType) {
                                Array.setShort(array, i, (Short)item);
                                continue;
                            }
                            throw new UnexpectedException("Unknown primitive type");
                        }
                        Array.set(array, i, item);
                    }
                    return array;
                }
            };
        }
        return null;
    }

    @Override
    protected String paramName(int i) {
        return methodMetaInfoHolder.get().param(i).name();
    }

    private List<OptionLoader> ensureOptionLoaders(Method method, CommandMethodMetaInfo methodMetaInfo) {
        List<OptionLoader> optionLoaders = (List<OptionLoader>)this.optionLoaderRegistry.get(method);
        if (null == optionLoaders) {
            optionLoaders = this.findOptionLoaders(method, methodMetaInfo);
            this.optionLoaderRegistry.put(method, optionLoaders);
        }
        return optionLoaders;
    }

    private List<OptionLoader> findOptionLoaders(Method method, CommandMethodMetaInfo methodMetaInfo) {
        ArrayList<OptionLoader> optionLoaders = new ArrayList<OptionLoader>();
        this.findParamOptionLoaders(method, methodMetaInfo, optionLoaders);
        this.findFieldOptionLoaders(method.getDeclaringClass(), optionLoaders);
        return optionLoaders;
    }

    private void findFieldOptionLoaders(Class c, List<OptionLoader> optionLoaders) {
        if (this.injector.isProvided(c)) {
            return;
        }
        for (Field field : $.fieldsOf((Class)c, (boolean)true)) {
            String bindName;
            Annotation[] annotations;
            Type type = field.getGenericType();
            BeanSpec spec = BeanSpec.of((Type)type, (Annotation[])(annotations = field.getAnnotations()), (String)(bindName = CliContextParamLoader.bindName(annotations, field.getName())), (Injector)this.injector);
            boolean provided = this.injector.isProvided(spec);
            ParamValueLoader loader = provided ? ProvidedValueLoader.get(spec, this.injector) : this.findContextSpecificLoader(bindName, spec);
            if (!(loader instanceof OptionLoader)) continue;
            optionLoaders.add((OptionLoader)loader);
        }
    }

    private void findParamOptionLoaders(Method m, CommandMethodMetaInfo methodMetaInfo, List<OptionLoader> optionLoaders) {
        Type[] types = m.getGenericParameterTypes();
        int len = types.length;
        if (len == 0) {
            return;
        }
        Annotation[][] allAnnotations = m.getParameterAnnotations();
        for (int i = len - 1; i >= 0; --i) {
            ParamValueLoader loader;
            Annotation[] annotations = allAnnotations[i];
            Type type = types[i];
            BeanSpec spec = BeanSpec.of((Type)type, (Annotation[])annotations, null, (Injector)this.injector);
            String bindName = CliContextParamLoader.tryFindBindName(annotations, spec.name());
            if (null == bindName) {
                bindName = methodMetaInfo.param(i).name();
            }
            if ((loader = this.findContextSpecificLoader(bindName, spec)) instanceof OptionLoader) {
                optionLoaders.add((OptionLoader)loader);
                continue;
            }
            if ($.isSimpleType((Class)spec.rawType())) continue;
        }
    }
}

