/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.app.ActionContext;
import act.app.App;
import act.app.data.StringValueResolverManager;
import act.inject.DependencyInjector;
import act.inject.param.JsonDTO;
import act.inject.param.ParamValueLoader;
import act.util.ActContext;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.inject.BeanSpec;

class JsonParamValueLoader
implements ParamValueLoader {
    private static final Provider NULL_PROVIDER = new Provider(){

        public Object get() {
            return null;
        }
    };
    private ParamValueLoader fallBack;
    private BeanSpec spec;
    private Provider defValProvider;
    private boolean isPathVariable;

    JsonParamValueLoader(ParamValueLoader fallBack, BeanSpec spec, DependencyInjector<?> injector) {
        this.fallBack = (ParamValueLoader)$.notNull((Object)fallBack);
        this.spec = (BeanSpec)$.notNull((Object)spec);
        this.defValProvider = JsonParamValueLoader.findDefValProvider(spec, injector);
        ActionContext ctx = ActionContext.current();
        if (null != ctx) {
            this.isPathVariable = ctx.isPathVar(spec.name());
        }
    }

    @Override
    public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
        if (this.isPathVariable) {
            return this.fallBack.load(bean, context, noDefaultValue);
        }
        JsonDTO dto = (JsonDTO)context.attribute("__json_dto__");
        if (null == dto) {
            return this.fallBack.load(bean, context, noDefaultValue);
        }
        Object o = dto.get(this.spec.name());
        return null != o ? o : this.defValProvider.get();
    }

    @Override
    public String bindName() {
        return this.spec.name();
    }

    private static Provider findDefValProvider(BeanSpec beanSpec, DependencyInjector<?> injector) {
        final Class c = beanSpec.rawType();
        final StringValueResolverManager resolver = App.instance().resolverManager();
        if (c.isPrimitive()) {
            return new Provider(){

                public Object get() {
                    return resolver.resolve(null, c);
                }
            };
        }
        if (Collection.class.isAssignableFrom(c) || Map.class.isAssignableFrom(c)) {
            return injector.getProvider(c);
        }
        if (c.isArray()) {
            return new Provider(){

                public Object get() {
                    return Array.newInstance(c.getComponentType(), 0);
                }
            };
        }
        return NULL_PROVIDER;
    }
}

