/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.cli.CliContext;
import act.cli.Optional;
import act.cli.Required;
import act.inject.param.CliParamValueLoader;
import act.inject.param.ParamValueLoader;
import act.util.ActContext;
import org.osgl.inject.BeanSpec;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

class OptionLoader
extends CliParamValueLoader
implements ParamValueLoader {
    final String bindName;
    String lead1;
    String lead2;
    final String defVal;
    final String requiredGroup;
    final boolean required;
    final BeanSpec beanSpec;
    final String errorTemplate;
    private final StringValueResolver resolver;

    OptionLoader(String bindName, Optional optional, StringValueResolver resolver, BeanSpec beanSpec) {
        this.bindName = bindName;
        this.required = false;
        this.parseLeads(optional.lead());
        this.defVal = optional.defVal();
        this.requiredGroup = null;
        this.beanSpec = beanSpec;
        this.errorTemplate = this.errorTemplate(optional);
        this.resolver = resolver;
        CliContext.ParsingContextBuilder.foundOptional();
    }

    OptionLoader(String bindName, Required required, StringValueResolver resolver, BeanSpec beanSpec) {
        this.bindName = bindName;
        this.required = true;
        this.parseLeads(required.lead());
        this.defVal = null;
        String group = required.group();
        this.requiredGroup = S.blank((String)group) ? bindName : group;
        this.beanSpec = beanSpec;
        this.errorTemplate = this.errorTemplate(required);
        this.resolver = resolver;
        CliContext.ParsingContextBuilder.foundRequired(this.requiredGroup);
    }

    @Override
    public Object load(Object cachedBean, ActContext<?> context, boolean noDefaultValue) {
        CliContext ctx = (CliContext)context;
        String optVal = ctx.paramVal(this.bindName);
        if (S.blank((String)optVal) && this.required) {
            optVal = this.getFirstArgument(ctx);
        }
        Object val = null;
        if (S.notBlank((String)optVal)) {
            val = this.resolve(optVal);
        }
        if (null == val && null != cachedBean) {
            val = cachedBean;
        }
        if (null == val && !this.required) {
            Object object = val = S.notBlank((String)this.defVal) ? this.resolve(this.defVal) : this.resolve(null);
        }
        if (null != val && this.required) {
            ctx.parsingContext().foundRequired(this.requiredGroup);
        }
        return val;
    }

    @Override
    public String bindName() {
        return this.bindName;
    }

    private Object resolve(String val) {
        return this.resolve(val, this.resolver);
    }

    private <T> T resolve(String val, StringValueResolver<T> resolver) {
        if (null == this.errorTemplate) {
            return (T)resolver.resolve(val);
        }
        try {
            return (T)resolver.resolve(val);
        }
        catch (Exception e) {
            throw E.unexpected((String)this.errorTemplate, (Object[])new Object[]{val});
        }
    }

    private String errorTemplate(Optional optional) {
        return this.verifyErrorTemplate(optional.errorTemplate());
    }

    private String errorTemplate(Required required) {
        return this.verifyErrorTemplate(required.errorTemplate());
    }

    private String verifyErrorTemplate(String s) {
        if (S.blank((String)s)) {
            return null;
        }
        if (!s.contains("%")) {
            throw E.invalidConfiguration((String)("Error template must have format argument placeholder, e.g. %s inside it: " + s), (Object[])new Object[0]);
        }
        if (s.split("%").length > 2) {
            throw E.invalidConfiguration((String)("Error template must not have  more than one format argument placeholder, e.g. %s inside it: " + s), (Object[])new Object[0]);
        }
        return s;
    }

    private void parseLeads(String[] specs) {
        this.lead1 = specs[0];
        if (specs.length > 1) {
            this.lead2 = specs[1];
        } else {
            String[] sa = this.lead1.split("[,;\\s]+");
            if (sa.length > 2) {
                throw E.unexpected((String)"Option cannot have more than two leads", (Object[])new Object[0]);
            }
            if (sa.length > 1) {
                this.lead1 = sa[0];
                this.lead2 = sa[1];
            }
        }
        if (S.blank((String)this.lead1)) {
            this.lead1 = "-" + this.bindName.charAt(0);
            this.lead2 = "--" + Keyword.of((CharSequence)this.bindName).dashed();
        }
    }
}

