/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.inject.genie.RequestScope;
import act.inject.genie.SessionScope;
import act.inject.param.ParamValueLoader;
import act.inject.param.ScopeCacheSupport;
import act.util.ActContext;
import org.osgl.inject.BeanSpec;

class ScopedParamValueLoader
implements ParamValueLoader {
    private ParamValueLoader realLoader;
    private String key;
    private ScopeCacheSupport scopeCache;

    ScopedParamValueLoader(ParamValueLoader loader, BeanSpec beanSpec, ScopeCacheSupport scopeCache) {
        this.realLoader = loader;
        this.scopeCache = scopeCache;
        this.key = scopeCache.key(beanSpec);
    }

    @Override
    public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
        Object requestScoped;
        boolean isSession;
        Object cached = this.scopeCache.get(this.key);
        boolean bl = isSession = SessionScope.INSTANCE == this.scopeCache;
        if (isSession && null != (requestScoped = RequestScope.INSTANCE.get(this.key))) {
            return requestScoped;
        }
        cached = this.realLoader.load(cached, context, noDefaultValue);
        this.scopeCache.put(this.key, cached);
        if (isSession) {
            RequestScope.INSTANCE.put(this.key, cached);
        }
        return cached;
    }

    @Override
    public String bindName() {
        return this.realLoader.bindName();
    }
}

