/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.app.ActionContext;
import act.app.App;
import act.inject.DefaultValue;
import act.inject.param.ParamValueLoader;
import act.inject.param.StringValueResolverValueLoaderBase;
import act.util.ActContext;
import org.osgl.inject.BeanSpec;
import org.osgl.util.AnnotationAware;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

class SessionValueLoader
implements ParamValueLoader {
    private final String key;
    private final Class targetType;
    private final StringValueResolver stringValueResolver;
    private final Object defVal;

    public SessionValueLoader(String name, BeanSpec beanSpec) {
        this.key = this.key(name, beanSpec);
        this.targetType = beanSpec.rawType();
        this.stringValueResolver = App.instance().resolverManager().resolver(this.targetType, (AnnotationAware)beanSpec);
        E.illegalArgumentIf((null == this.stringValueResolver ? 1 : 0) != 0, (String)"Cannot find out StringValueResolver for %s", (Object[])new Object[]{beanSpec});
        DefaultValue defValAnno = (DefaultValue)beanSpec.getAnnotation(DefaultValue.class);
        this.defVal = null != defValAnno ? this.stringValueResolver.resolve(defValAnno.value()) : StringValueResolverValueLoaderBase.defVal(null, this.targetType);
    }

    @Override
    public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
        if (context instanceof ActionContext) {
            return this.load((ActionContext)context, noDefaultValue);
        }
        throw E.unsupport();
    }

    private Object load(ActionContext context, boolean noDefaultValue) {
        String value = context.session(this.key);
        Object obj = null == value ? null : this.stringValueResolver.resolve(value);
        return null == obj && !noDefaultValue ? this.defVal : obj;
    }

    @Override
    public String bindName() {
        return this.key;
    }

    private String key(String name, BeanSpec spec) {
        if (S.notBlank((String)name)) {
            return name;
        }
        return spec.name();
    }
}

