/*
 * Decompiled with CFR 0.152.
 */
package act.inject.util;

import act.Act;
import act.app.App;
import act.app.data.StringValueResolverManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.osgl.$;
import org.osgl.exception.UnexpectedException;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Genie;
import org.osgl.inject.Injector;
import org.osgl.inject.ValueLoader;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class ResourceLoader<T>
extends ValueLoader.Base<T> {
    protected static final Logger LOGGER = LogManager.get(ResourceLoader.class);
    protected Object resource;
    private static Injector injector = Genie.create((Object[])new Object[0]);

    protected void initialized() {
        boolean trimLeadingSlash;
        String path = (String)this.options.get("value");
        E.unexpectedIf((boolean)S.blank((String)path), (String)"resource path not specified", (Object[])new Object[0]);
        boolean bl = trimLeadingSlash = (Boolean)this.options.get("skipTrimLeadingSlash") == false;
        while (trimLeadingSlash && path.startsWith("/")) {
            path = path.substring(1);
        }
        E.unexpectedIf((boolean)S.blank((String)path), (String)"resource path not specified", (Object[])new Object[0]);
        this.resource = ResourceLoader.load(path, this.spec);
    }

    public T get() {
        return (T)this.resource;
    }

    public static <T> T load(String path, Class<T> type) {
        return ResourceLoader.load(path, type, false);
    }

    public static <T> T load(String path, Class<T> type, boolean ignoreResourceNotFound) {
        return ResourceLoader.load(path, BeanSpec.of(type, (Injector)injector), ignoreResourceNotFound);
    }

    public static <T> T load(String path, TypeReference<T> typeReference) {
        return ResourceLoader.load(path, typeReference, false);
    }

    public static <T> T load(String path, TypeReference<T> typeReference, boolean ignoreResourceNotFound) {
        BeanSpec spec = BeanSpec.of((Type)typeReference.getType(), (Injector)injector);
        return ResourceLoader.load(path, spec, ignoreResourceNotFound);
    }

    public static <T> T load(String resourcePath, BeanSpec spec) {
        return ResourceLoader.load(resourcePath, spec, false);
    }

    public static <T> T load(String resourcePath, BeanSpec spec, boolean ignoreResourceNotFound) {
        return (T)$.cast((Object)ResourceLoader._load(resourcePath, spec, ignoreResourceNotFound));
    }

    protected static Object _load(String resourcePath, BeanSpec spec, boolean ignoreResourceNotFound) {
        URL url = ResourceLoader.loadResource(resourcePath);
        if (null == url) {
            if (!ignoreResourceNotFound) {
                LOGGER.warn("resource not found: " + resourcePath);
            }
            return null;
        }
        boolean isJson = resourcePath.endsWith(".json");
        Class rawType = spec.rawType();
        if (URL.class == rawType) {
            return url;
        }
        if (String.class == rawType) {
            return IO.readContentAsString((URL)url);
        }
        if (byte[].class == rawType) {
            return ResourceLoader.readContent(url);
        }
        if (List.class.equals((Object)rawType)) {
            List typeParams = spec.typeParams();
            if (!typeParams.isEmpty()) {
                if (String.class == typeParams.get(0)) {
                    return IO.readLines((URL)url);
                }
                if (isJson) {
                    return JSON.parseObject((String)IO.readContentAsString((URL)url), (Type)spec.type(), (Feature[])new Feature[0]);
                }
            }
        } else if (Collection.class.isAssignableFrom(rawType)) {
            List typeParams = spec.typeParams();
            if (!typeParams.isEmpty()) {
                Collection col = (Collection)Act.getInstance(rawType);
                if (String.class == typeParams.get(0)) {
                    col.addAll(IO.readLines((URL)url));
                    return col;
                }
                StringValueResolverManager resolverManager = Act.app().resolverManager();
                try {
                    Class componentType = spec.componentSpec().rawType();
                    List stringList = IO.readLines((URL)url);
                    for (String line : stringList) {
                        col.add(resolverManager.resolve(line, componentType));
                    }
                }
                catch (RuntimeException e) {
                    throw new UnexpectedException("return type not supported: " + spec);
                }
            }
        } else {
            if (ByteBuffer.class == rawType) {
                byte[] ba = ResourceLoader.readContent(url);
                ByteBuffer buffer = ByteBuffer.allocateDirect(ba.length);
                buffer.put(ba);
                buffer.flip();
                return buffer;
            }
            if (Path.class.isAssignableFrom(rawType)) {
                try {
                    return Paths.get(url.toURI());
                }
                catch (URISyntaxException exception) {
                    throw E.unexpected((Throwable)exception);
                }
            }
            if (File.class.isAssignableFrom(rawType)) {
                return new File(url.getFile());
            }
            if (ISObject.class.isAssignableFrom(rawType)) {
                return SObject.of((byte[])ResourceLoader.readContent(url));
            }
            if (InputStream.class == rawType) {
                return IO.is((URL)url);
            }
            if (Reader.class == rawType) {
                return new InputStreamReader(IO.is((URL)url));
            }
        }
        if (isJson) {
            return JSON.parseObject((String)IO.readContentAsString((URL)url), (Type)spec.type(), (Feature[])new Feature[0]);
        }
        try {
            return Act.app().resolverManager().resolve(IO.readContentAsString((URL)url), rawType);
        }
        catch (RuntimeException e) {
            throw new UnexpectedException("return type not supported: " + spec);
        }
    }

    private static byte[] readContent(URL url) {
        return IO.readContent((InputStream)IO.is((URL)url));
    }

    private static URL loadResource(String path) {
        App app = Act.app();
        if (null == app || null == app.classLoader()) {
            return ResourceLoader.class.getClassLoader().getResource(path);
        }
        return app.classLoader().getResource(path);
    }
}

